function screen2tiff (filename, nocompression)

%SCREEN2JPEG Generate a JPEG file of the current figure with
%   dimensions consistent with the figure's screen dimensions.
%
%   SCREEN2JPEG('filename') saves the current figure to the
%   JPEG file "filename".
%

%    Sean P. McCarthy
%    Copyright (c) 1984-98 by The MathWorks, Inc. All Rights Reserved

if nargin < 1
  disp ('# ERROR #: screen2tiff -- Not enough input arguments!')
  help screen2tiff; return;
elseif (nargin == 1)
  op = '-dtiff'; 
elseif (nargin == 2)
  if (nocompression == 0)
    op = '-dtiff';
  else
    op = '-dtiffnocompression';
  end;
end;

%keyboard

oldscreenunits = get(gcf,'Units');
oldpaperunits  = get(gcf,'PaperUnits');
oldpaperpos    = get(gcf,'PaperPosition');
set (gcf,'Units','pixels');

scrpos = get(gcf,'Position');
newpos = scrpos/100;
set(gcf,'PaperUnits','inches',...
    'PaperPosition',newpos)

eval(['print ', op, ' ', filename, ' -r100'])
drawnow
set(gcf,'Units',oldscreenunits,...
    'PaperUnits',oldpaperunits,...
    'PaperPosition',oldpaperpos)

