% ctrans1.m
% ------------------------------------------------------ 
% Plot 2 point sets, w/ black background.
%
%
% Usage:      y =ctrans1 (x, theta, tx, ty, s)
% Parameters: 
%     x, y point sets.
%
% Return:  None.
% ------------------------------------------------------
% Last modified: 11/07/97 

function [y] = ctrans1 (x, theta, tx, ty, s);


% Be consistent: 
cs = cos(theta); 
sn = sin(theta); 
R = [cs, -sn; sn, cs]; % same as cpgm_rotate, main.

ry = x * R' .* s;

t = [tx, ty];
for i=1:2
  y (:,i) = ry (:,i) + t(i);
end

figure (2); clf; 
cplot (x, 'go', 6); hold on;
cplot (y, 'r+', 6); title ('ctrans1 output');
