% ---------------------------------------------------------
% ctps_plot_grid.m
% ---------------------------------------------------------
% Display TPS deformed grid.
%
% Usage: 
% [] = ctps_plot_grid (x,y,c,d);
% [] = ctps_plot_grid (x,y,lamda);
% [] = ctps_plot_grid (x,y,c,d,  resolution,resolution_grid); 
% [] = ctps_plot_grid (x,y,lamda,resolution,resolution_grid); 
%
% for (x,y,c,d)
% x -- TPS basis points.
% y -- points to be warped.
%
% for (x,y,lamda)
% x -- TPS basis points and points to be warped.
% y -- target points.
%
% 01/26/00


function [] = ctps_plot_grid (x,y,c,d,...
    resolution,resolution_grid,in7);

debug_flag = 0;

% t = [7,6; 10,9; 1 1; 1 15; 15 1; 15 15];
% y = [11,7; 7,10; 1 1; 1 15; 15 1; 15 15];
% [c,d] = ctps_gen (t, y, 1);

[jnk,dim] = size(x);

if dim == 2
  resolution_default = 4;
  resolution_grid_d  = 3;
elseif dim == 3
  resolution_default = 2;
  resolution_grid_d  = 2;
end;

% check input.
% ------------
if (nargin == 3);     % input (x,y,lamda);
  lamda = c;
  [c,d] = ctps_gen (x,y,lamda);
  tmp = x;  y = x; x = tmp;

  resolution      = resolution_default;
  resolution_grid = resolution_grid_d;

elseif (nargin == 4); % input (x,y,c,d);
  resolution      = resolution_default;
  resolution_grid = resolution_grid_d;

elseif (nargin == 5); % input (x,y,lamda,resolution,resolution_grid); 
  lamda           = c; 
  resolution_grid = resolution;
  resolution      = d;
  [c,d]           = ctps_gen (x,y,lamda);
  tmp = x;  y = x; x = tmp;
  
elseif (nargin == 6);  % input (x,y,c,d,resolution,resolution_grid); 
  % do nothing.

elseif (nargin >= 8);
  disp ('# ERROR #: ctps_plot_grid -- wrong input!');
  help ctps_plot_grid; return;
end;


disp_flag = 'both';
if nargin == 7
  if in7 == 0
    disp_flag = 'both';
  elseif in7 == 1
    disp_flag = 'def_only';
  elseif in7 == 2
    disp_flag = 'ori_only';
  end;
end;


switch (dim)
  
  case 2
    % generate grid points. 
    [grid_pts, controls] = ctps_plot_grid_gen (x, resolution, resolution_grid);
    
    % Warp the grid:
    [grid_new] = ctps_warp_pts (grid_pts, x, c, d); 
    
    
    % Plot:
    ori_color = ones(1,3) * 0.7;
    new_color = 'b';
    
    if ~strcmp (disp_flag, 'def_only')
      ctps_plot_gridbox (1, grid_pts, controls, ori_color, ':'); hold on;
    end;
    if ~strcmp (disp_flag, 'ori_only');
      ctps_plot_gridbox (1, grid_new, controls, 'b','-'); hold on;
      %axis('equal'); axis ('off');
    end;
  
  case 3
    %resolution = 2;
    %resolution_grid = 3;
    %    resolution, resolution_grid;
    % generate grid points. 
    [grid_pts,ns,n1] = cplot_3d_genbox (x,resolution,resolution_grid);
    if debug_flag; disp ('point generated ...'); end;

    % Warp the grid:
    [grid_new] = ctps_warp_pts (grid_pts, x, c, d); 
    if debug_flag; disp ('warp generated ...'); end;
    % Plot:
    if ~strcmp (disp_flag, 'def_only')
      cplot_3d_box (grid_pts, ns, n1, 'w', ':'); hold on;
    end;
    if ~strcmp (disp_flag, 'ori_only')
      cplot_3d_box (grid_new, ns, n1, 'b', '-'); hold on;
    end;
    axis equal; pause (0.01); 
    if debug_flag; disp ('display grid done ...'); end;
end;


