% cstat_model.m
% ------------------------------------------------------------------- 
% Look at the statistical shape model. 
%
% Usage: [] = cstat_model (x_list, nx);
% ------------------------------------------------------------------- 
% Last modified: 06/30/00

function [] = cstat_model (x_list, nx);

n_set = length(nx);

% calc mean:
x_mean = zeros(nx(1)*2,1);
for i=1:n_set
  x_now = x_list ((sum(nx(1:i-1))+1):sum(nx(1:i)),:);
  if i==1; x0=x_now; end;
  
  x_vec = cim2col (x_now);
  x_mean = x_mean + x_vec;
end;
x_mean = x_mean / n_set;

% calc covariance:
x_var = zeros (nx(1)*2,nx(1)*2);
for i=1:n_set
  x_now = x_list ((sum(nx(1:i-1))+1):sum(nx(1:i)),:);

  x_vec = cim2col (x_now);
  x_var = x_var + (x_vec-x_mean)*(x_vec-x_mean)';
end;
x_var = x_var / n_set;

% look at the eign-modes:
K       = x_var;
[vK,dK] = eig(K);

[eval_K,eval_ind_K] = sort(diag(abs(dK)));
tmp                 = diag (dK);
eval_K              = tmp (eval_ind_K);
vK_ind              = vK (:,eval_ind_K); % sort according the column.

n = length(x0);

subplot_flag = 1;
save_flag    = 0;

if save_flag; fig(1); clf; end;
if subplot_flag % disp 1st 16 modes only.
  nmin = n-15;
else
  nmin = 1;
end;

for i=2*n:-1:1
  disp([n-i+1, eval_K(i)]);
  fac = 0.5;
  nonrigid_dis = fac*(ccol2im(vK_ind(:,i),n,2));
  
  fac = 0.03 / max(max(abs(nonrigid_dis)));
  nonrigid_dis = fac*(ccol2im(vK_ind(:,i),n,2));
  
  x0 = ccol2im (x_mean, n, 2);
  x_new = x0 + nonrigid_dis;
  fig(1); clf; facq = 0.4;
  quiver(x0(:,1),x0(:,2), ...
      facq*nonrigid_dis(:,1), facq*nonrigid_dis(:,2)); hold on;
  cplot(x0,x_new); hold on;

  [c,d] = ctps_gen(x0,x_new,0.001);  
  ctps_plot_grid (x0,x_new,c,d);
  
  pause;
end;

