% ------------------------------------------------------------------- 
% csave.m
% ------------------------------------------------------------------- 
% Save matlab window --> eps, tif files.
%
% Usage: 
% [] = csave ('ps',  'pami', it, [figure_numbers]);
% [] = csave ('tif', 'pami', it, [figure_numbers]);
% [] = csave ('both', 'pami', it, [figure_numbers]);
%
% [] = csave ('psc', 'pami', it, [figure_numbers]);
% [] = csave ('bothc', 'pami', it, [figure_numbers])
% 
% 02/03/00

function [] = csave (method, prefix, it, fign);

keep_bg = 0;
if (nargin ~= 4)
  disp ('# ERROR #: cprint -- wrong input!');
  help csave; return;
  
elseif strcmp(method, 'tif')
  keep_bg        = 1;
  no_compression = 0;
  
elseif strcmp(method, 'jpg')
  keep_bg        = 1;
  no_compression = 0;

elseif strcmp(method, 'ps')
  keep_bg        = 0;
  no_compression = 0;
end;


figs_total = length(fign);
for it_fig=1:figs_total
  fig_now = fign(it_fig);
  figure(fig_now);
  
  if (keep_bg == 1)
    set(gcf,'InvertHardcopy','off');
  else
    set(gcf,'InvertHardcopy','on');
  end;

  % generate seq_str ("sequence string"):
  if it <= 9                       % single digit: '00x'
    seq_str = ['00',num2str(it)];
  elseif it <= 99                  % double digit: '0xx'
    seq_str = ['0',num2str(it)];
  elseif it <= 999                 % three digits: 'xxx'
    seq_str = [num2str(it)];
  end;  
  
  filename = [prefix,'_',seq_str,'_',num2str(fig_now)];
  if (strcmp(method, 'ps'))
    print ('-deps', [filename,'.eps']);
  
  elseif (strcmp(method, 'psc'))
    print ('-depsc', [filename,'.eps']);
  
  elseif (strcmp(method, 'tif'))
    screen2tiff ([filename,'.tif'], no_compression);
  
  elseif (strcmp(method, 'jpg'))
    screen2jpeg ([filename,'.jpg']);
  
  elseif (strcmp(method, 'both'))
    set(gcf,'InvertHardcopy','off');
    screen2tiff ([filename,'.tif'], 0);
    set(gcf,'InvertHardcopy','on');
    print ('-deps', [filename,'.eps']);
  
  elseif (strcmp(method, 'bothc'))
    set(gcf,'InvertHardcopy','off');
    screen2tiff ([filename,'.tif'], 0);
    set(gcf,'InvertHardcopy','on');
    print ('-depsc', [filename,'.eps']);
  end;
end;
