%%%%%
% 4 % %%% csMIX_plot_simple %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%
%
% Plot the csMIX progress. (no Cx, just T -- as isotropic covariance).
%
% Usage: 

% 
% 03/30/00

function [] = csMIX_plot_simple (method, x, y, z, v, vf, u, uf, ...
    mx, my, m_threshold, T, ...
    transformation_type, cx_tps, dx_tps, cy_tps, dy_tps, w, sigma, m_method);  



% configure:
xmarker  = 'go'; xsize = 6;
ymarker  = 'r+'; ysize = 6;
vmarker  = 'c^'; vsize = 12;
umarker  = 'm^'; usize = 12;
inter_marker = 'g+'; 


% -------------------------------------------------------------------
% Generate 3 windows.
% -------------------------------------------------------------------
[siz1,dim] = size (v);
[siz2,dim] = size (y);


% --- 2D data --------------------------------------------------------
if (dim == 2)
switch (method)
  case 2
    
    
    h_sub1 = subplot ('position', [0.05 0.55 0.4 0.4]); 
    cplotg (v, x, mx, m_threshold); hold on; 
    cMIX_plot_mixture_simple (v,T,'b-'); hold on;
    cplot (x, xmarker, xsize); hold on; 
    cplot (v, vmarker, vsize); hold on; 
    axis ('equal'); axis ('off'); title ('X and Clusters V');
    
    h_sub2 = subplot ('position', [0.55 0.55 0.4 0.4]);
    cplotg (u, y, my, m_threshold); hold on; 
    cMIX_plot_mixture_simple (u,T,'b-'); hold on;
    cplot (y, ymarker, ysize); hold on; 
    cplot (u, umarker, usize); hold on; 
    axis ('equal'); axis ('off'); title ('Y and Clusters U');


    h_sub3 = subplot ('position', [0.05 0.05 0.4 0.4]);
    ctps_plot_grid (v, v, cx_tps, dx_tps); hold on;
    cplot (y,  ymarker, ysize); hold on;
    cplot (vf, vmarker, vsize); hold on;
    axis('equal'); axis('off'); title ('TPS Warping (from X to Y)');

    h_sub4 = subplot ('position', [0.55 0.05 0.4 0.4]);
    ctps_plot_grid (u, u, cy_tps, dy_tps); hold on;
    cplot (x,  xmarker, xsize); hold on;
    cplot (uf, umarker, usize); hold on;
    axis('equal'); axis('off'); title ('TPS Warping (from Y to X)');

    fig(2); clf;
    subplot (311); 
    xnew = ctps_warp_pts (x, v, cx_tps, dx_tps);
    cplot (xnew, xmarker, xsize); hold on;
    cplot (y,    ymarker, ysize); hold on;

    subplot (312); 
    ynew = ctps_warp_pts (y, u, cy_tps, dy_tps);
    cplot (ynew, ymarker, ysize); hold on;
    cplot (x,    xmarker, xsize); hold on;
    
    subplot (313); 
    cplotg (u,v); hold on;
    cplot (u, umarker, usize); hold on;
    cplot (v, vmarker, vsize); hold on;
  
  otherwise;
end;



% --- 3D data --------------------------------------------------------
else 

switch (method)

  case 2

    h_sub1 = subplot ('position', [0.05 0.55 0.4 0.4]); 
    cplot (x, xmarker, xsize); hold on; 
    cplot (v, vmarker, vsize); hold on; 
    % cMIX_plot_mixture_simple (v(1,:),T); hold on;
    axis ('equal'); axis ('off'); title ('X and Clusters V');

    h_sub2 = subplot ('position', [0.55 0.55 0.4 0.4]);
    % cMIX_plot_mixture_simple (u(1,:),T); hold on;
    cplot (y, ymarker, ysize); hold on; 
    cplot (u, umarker, usize); hold on; 
    axis ('equal'); axis ('off'); title ('Y and Clusters U');


    h_sub3 = subplot ('position', [0.05 0.05 0.4 0.4]);
    ctps_plot_grid (v, v, cx_tps, dx_tps); hold on;
    cplot (y,  ymarker, ysize); hold on;
    cplot (vf, vmarker, vsize); hold on;
    axis('equal'); axis('off'); title ('TPS Warping (from X to Y)');

    h_sub4 = subplot ('position', [0.55 0.05 0.4 0.4]);
    ctps_plot_grid (u, u, cy_tps, dy_tps); hold on;
    cplot (x,  xmarker, xsize); hold on;
    cplot (uf, umarker, usize); hold on;
    axis('equal'); axis('off'); title ('TPS Warping (from Y to X)');

    fig(2); clf;
    subplot (311); 
    xnew = ctps_warp_pts (x, v, cx_tps, dx_tps);
    cplot (xnew(:,1:2), xmarker, xsize); hold on;
    cplot (y(:,1:2),    ymarker, ysize); hold on;
    cMIX_plot_mixture_simple (xnew(1,1:2),T); hold on;
    axis off;
    
    subplot (312); 
    ynew = ctps_warp_pts (y, u, cy_tps, dy_tps);
    cplot (ynew(:,1:2), ymarker, ysize); hold on;
    cplot (x(:,1:2),    xmarker, xsize); hold on;
    % axis_save = axis; axis off;
    axis off;
    
    subplot (313); 
    cplotg (u,v); hold on;
    cplot (u, umarker, usize); hold on;
    cplot (v, vmarker, vsize); hold on;
    %axis (axis_save);
    
  otherwise;
    
end;

end;


