% -------------------------------------------------------------------
% crbf_warp_img_2d3d.m
% --------------------------------------------------------------
% Warp one slice of 3D volume data based on RBF.
% !!! Need inverse/backward transformation parameters. !!!
%
% Usage:  
% [img1] = crbf_warp_image (vol,r,c,s,sn,z,w,sigma);
% 
% Notes: sn -- sagittal slice #.
%        (recommended value: 60).
%
% 09/30/00

function [img1] = crbf_warp_img_2d3d (vol,r,c,s,sn,z,w,sigma);

% check input.
if nargin ~= 8
  disp ('# ERROR #: crbf_warp_img -- wrong input !');
  help crbf_warp_img_2d3d; return;
end;


% generate original grid.
% -----------------------
disp ('warping grid ...');

img0              = zeros (r,c);
[rows,cols]       = size(img0);
[grid_x0,grid_y0] = meshgrid (1:cols,1:rows);
grid_x0           = cim2col(grid_x0);
grid_y0           = cim2col(grid_y0);
grid_z0           = ones(length(grid_x0),1) * sn;
grid_old          = [grid_x0,grid_y0,grid_z0]; 

grid_new          = grid_old *0;

% warp the grid points row-by-row.
% --------------------------------
complete_percent = 0;
for it_row=1:rows
  grid_old_now = grid_old ((it_row-1)*cols+1:it_row*cols,:);
  
  [dim1, dim2] = size(z); % d     -- affine: dim > 1
                          % lamda -- par:    dim = 1.
  
  % --- [pts1] = crbf_warp_pts (pts, x, c, d) --------------------------
  if dim1 > 1
    [grid_new_now] = crbf_warp_pts (grid_old_now,z,w,sigma);
  end;

  % Discretize the grid:
  grid_new_now = round(grid_new_now);
  
  grid_new ((it_row-1)*cols+1:it_row*cols,:) = grid_new_now; 
  
  if it_row/rows > complete_percent
    str = sprintf ('%2.0f percent complete ', it_row/rows*100); disp(str); 
    complete_percent = complete_percent + 0.1;
  end;
end;
disp ('');

% warp image.
% -----------
disp ('warpping image, interpolating ...');
new_index = grid_new(:,1) + (grid_new(:,2)-1)*cols + ...
    (grid_new(:,3)-1)*rows*cols;

img1 = zeros (rows*cols,1);

valid_index = find (grid_new(:,1) >= 1 & grid_new(:,1) <= cols & ...
    grid_new(:,2) >= 1 & grid_new(:,2) <= rows & ...
    grid_new(:,3) >= 1 & grid_new(:,3) <= s);

real_new_index = new_index (valid_index);
img1(valid_index) = vol(real_new_index);
img1 = ccol2im (img1, rows,cols); 

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = temp;

grid_x1 = ccol2im(grid_new(:,1), rows, cols);
grid_y1 = ccol2im(grid_new(:,2), rows, cols);

[grid_x0,grid_y0] = meshgrid (1:cols,1:rows);
grid_x0 = double (grid_x0);
grid_y0 = double (grid_y0);

img1 = interp2 (grid_x0, grid_y0, img0, grid_x1, grid_y1);
