% ------------------------------------------------------------------------
% crbf_randpts.m
% ------------------------------------------------------------------------
% Generate random RBF and warp the input pts.
%
% Usage:
% [x1, w] = crbf_randpts (x,z,beta1,beta2,sigma);
%   
% Output: y -- warpped x with (w).
%         w -- RBF parameters.
%
% 01/26/00

function [x1, w] = crbf_randpts (x,z,beta1,beta2,sigma);

% check input:
if (nargin ~= 5)
  disp ('# ERROR #: crbf_randpts -- wrong input!');
  help crbf_randpts; return;
end;

% Randomly generating c,d.
% ------------------------
[n,dim] = size(z);
M = dim + 1; % for 2D.

w = beta1 * randn (n,dim);         % warping part, dim n.
w = [w; beta2 * randn(dim,dim) + eye(dim,dim)];% afffine part, dim 2.
w = [w; beta2 * randn(1,dim)];            % translation part.

[phi] = crbf_gen (x,z,sigma);
x1    = phi * w;

figure(2); clf; figb;
% crbf_plot_grid (x, z, w,sigma);
% axis('equal');

if dim == 2
  cplot(x, 'go',6); hold on; 
  cplot(x1,'r+',6);
  %cplot_2g_simple ('', x, x1, eye(length(x)), 0);
elseif dim == 3
  [c,d] = ctps_gen (x,x1,0.0001);
  ctps_plot_grid (x,x1,c,d,2,4);
  % crbf_plot_grid (x, z, w, sigma); hold on;
  cplot (x,x1); hold on; cplotg(x,x1); hold on;
  cplotg (x, x1);
  view (-15,50);
end;
pause(0.1);
