% ---------------------------------------------------------
% crbf_plot_grid.m
% ---------------------------------------------------------
% Display RBF deformed grid.
%
% Usage: 
% [] = crbf_plot_grid (x,z,w,sig);
% [] = crbf_plot_grid (x,z,w,sig,  resolution,resolution_grid); 
%
% 09/19/00


function [] = crbf_plot_grid (x,z,w,sig,...
    resolution,resolution_grid,in7);

debug_flag = 0;

% t = [7,6; 10,9; 1 1; 1 15; 15 1; 15 15];
% y = [11,7; 7,10; 1 1; 1 15; 15 1; 15 15];
% [c,d] = crbf_gen (t, y, 1);

[jnk,dim] = size(x);

if dim == 2
  resolution_default = 4;
  resolution_grid_d  = 3;
elseif dim == 3
  resolution_default = 2;
  resolution_grid_d  = 2;
end;

% check input.
% ------------
if (nargin == 4); % input (x,z,w,sigma)
  resolution      = resolution_default;
  resolution_grid = resolution_grid_d;

elseif (nargin == 6);  % input (x,z,w,sigma,resolution,resolution_grid); 
  % do nothing.

elseif (nargin >= 8);
  disp ('# ERROR #: crbf_plot_grid -- wrong input!');
  help crbf_plot_grid; return;
end;


disp_flag = 'both';
if nargin == 7
  if in7 == 0
    disp_flag = 'both';
  elseif in7 == 1
    disp_flag = 'def_only';
  elseif in7 == 2
    disp_flag = 'ori_only';
  end;
end;


switch (dim)
  
  case 2
    % generate grid points. 
    [grid_pts, controls] = ctps_plot_grid_gen (x, resolution, resolution_grid);
    
    % Warp the grid:
    [grid_new] = crbf_warp_pts (grid_pts, z, w, sig);
    
    
    % Plot:
    ori_color = ones(1,3) * 0.7;
    new_color = 'b';
    
    if ~strcmp (disp_flag, 'def_only')
      ctps_plot_gridbox (1, grid_pts, controls, ori_color, ':'); hold on;
    end;
    if ~strcmp (disp_flag, 'ori_only');
      ctps_plot_gridbox (1, grid_new, controls, 'b','-'); hold on;
      %axis('equal'); axis ('off');
    end;
  
  case 3
    %resolution = 2;
    %resolution_grid = 3;
    %    resolution, resolution_grid;
    % generate grid points. 
    [grid_pts,ns,n1] = cplot_3d_genbox (x,resolution,resolution_grid);
    if debug_flag; disp ('point generated ...'); end;

    % Warp the grid:
    [grid_new] = crbf_warp_pts (grid_pts, z, w,sig);
    if debug_flag; disp ('warp generated ...'); end;
    % Plot:
    if ~strcmp (disp_flag, 'def_only')
      cplot_3d_box (grid_pts, ns, n1, 'w', ':'); hold on;
    end;
    if ~strcmp (disp_flag, 'ori_only')
      cplot_3d_box (grid_new, ns, n1, 'm', '-'); hold on;
    end;
    axis equal; pause (0.01); 
    if debug_flag; disp ('display grid done ...'); end;
end;


