% -------------------------------------------------------------
% crbf_gen_z.m
% -------------------------------------------------------------
% Generate z (basis pts) from x (data pts) by using the grid
% generating mechanism.
%
% Usage: 
% [z] = crbf_gen_z (x, resolution);

function [z] = crbf_gen_z (x, resolution);



% Generate grid data:
% -------------------
xrange = [min(x(:,1)), max(x(:,1))]; % only for 2D now.
yrange = [min(x(:,2)), max(x(:,2))];

% expand a little bit:
expand_ratio = 3;
xrange (1) = xrange (1) - (xrange(2)-xrange(1))/expand_ratio;
xrange (2) = xrange (2) + (xrange(2)-xrange(1))/expand_ratio;
yrange (1) = yrange (1) - (yrange(2)-yrange(1))/expand_ratio;
yrange (2) = yrange (2) + (yrange(2)-yrange(1))/expand_ratio;

%resolution = 10;
resolution_grid = 3;

% a: grid square size.
a = min(xrange(2)-xrange(1), yrange(2)-yrange(1)) / resolution;
grid_step = a / resolution_grid;

rows = ceil((yrange(2)-yrange(1)) / a + 1);
cols = ceil((xrange(2)-xrange(1)) / a + 1);

yrange(2) = yrange(1) + (rows-1)*resolution_grid*grid_step;
xrange(2) = xrange(1) + (cols-1)*resolution_grid*grid_step;

%keyboard

grid_pts = [];
points_row = (cols-1) * resolution_grid + 1; % two ending points.
points_col = (rows-1) * resolution_grid + 1; % two ending points.
for i=1:rows
  for j=1:cols
    tmp_y    = (i-1) * a + yrange(1);
    tmp_x    = (j-1) * a + xrange(1);
    grid_pts = [grid_pts; [tmp_x, tmp_y]];
  end;
end;


z = grid_pts;

figure(2); clf;
cplot_2 (x,z);