% ------------------------------------------------------------------- 
% cprint.m
% ------------------------------------------------------------------- 
% Print matlab window --> eps, tif files.
%
% Usage: 
% [] = cprint (filename, keep_bg, nocompression)
% 
% 02/03/00

function [] = cprint (method, filename, keep_bg, nocompression)

if (nargin<1) | (nargin>4)
  disp ('# ERROR #: cprint -- wrong input!');
  help cprint; return;
  
elseif (nargin == 2)
  if strcmp(method, 'tif')
    keep_bg      = 1;
  else
    keep_bg      = 0;
  end;
  no_compression = 0;
  
elseif (nargin == 3)
  no_compression = 0;
end;


if (keep_bg == 1)
  set(gcf,'InvertHardcopy','off');
else
  set(gcf,'InvertHardcopy','on');
end;

if (strcmp(method, 'ps'))
  print ('-deps', filename);
elseif (strcmp(method, 'tif'))
  screen2tiff (filename, nocompression);
end;

set (gcf,'InvertHardcopy','on');
