% cplot_3d_gen1box.m
% ------------------------------------------------------------------- 
% Generate *ONE* 3D grid boxes for plotting.
%
% Usage: [gridbox_pts] = cplot_3d_genbox (pt0, pt1,resolution_grid);
%
%        pt0 -- [x0 y0 z0]; the two extreme points.
%        pt1 -- [x1 y1 z1];
% ------------------------------------------------------------------- 
% Last modified: 

function [gridbox_pts] = cplot_3d_gen1box (pt0, pt1,resolution_grid);

x0 = pt0(1);
y0 = pt0(2);
z0 = pt0(3);

x1 = pt1(1);
y1 = pt1(2);
z1 = pt1(3);

vert1 = [x0 y0 z0];
vert2 = [x1 y0 z0];
vert3 = [x1 y1 z0];
vert4 = [x0 y1 z0];
vert5 = [x0 y0 z1];
vert6 = [x1 y0 z1];
vert7 = [x1 y1 z1];
vert8 = [x0 y1 z1];


gridbox_pts = [vert1; ...
  cinter_pts(vert1,vert2,resolution_grid);
  vert2; ...
  cinter_pts(vert2,vert3,resolution_grid);
  vert3; ...
  cinter_pts(vert3,vert4,resolution_grid);
  vert4; ...
  cinter_pts(vert4,vert1,resolution_grid);
  vert1; ...
  cinter_pts(vert1,vert5,resolution_grid);
  vert5; ...
  cinter_pts(vert5,vert6,resolution_grid);
  vert6; ...
  cinter_pts(vert6,vert7,resolution_grid);
  vert7; ...
  cinter_pts(vert7,vert8,resolution_grid);
  vert8; ...
  cinter_pts(vert8,vert5,resolution_grid);
  vert5; ...
  cinter_pts(vert5,vert8,resolution_grid);
  vert8; ...
  cinter_pts(vert8,vert4,resolution_grid);
  vert4; ...
  cinter_pts(vert4,vert3,resolution_grid);
  vert3; ...
  cinter_pts(vert3,vert7,resolution_grid);
  vert7; ...
  cinter_pts(vert7,vert6,resolution_grid);
  vert6; ...
  cinter_pts(vert6,vert2,resolution_grid);
  vert2]; 


  
function [inter_pts] = cinter_pts (pt0,pt1,resolution_grid);

[junk,dim] = size(pt0);
b = (pt1-pt0)/resolution_grid;

% keyboard

n = resolution_grid - 1;

if n >= 1
  inter_pts = zeros (n,dim);
  for i=1:dim
    tmp = (pt0(1,i)+b(i)*[0:n+1])';
    inter_pts (:,i) = tmp(2:2+n-1);
  end;
  
else
  inter_pts = [];
end;
