% cplot_2d_genbox.m
% ------------------------------------------------------------------- 
% Generate *ALL* 2D grid boxes for plotting.
%
% Usage: [gridbox_pts] = cplot_2d_genbox (x,resolution,resolution_box);
%
% ------------------------------------------------------------------- 
% Last modified: 06/20/2000

function [grid_pts,ns,n1] = cplot_2d_genbox (x,resolution,resolution_grid);

debug_flag = 0;

dim = 3;

% set grid range:
% ---------------
xrange = []; % [x0,x1; y0 y1; z0 z1]; lower/upper limit x,y,z axis.
for i=1:dim
  xrange = [xrange; min(x(:,i)), max(x(:,i))]; 
end;
  
% expand a little bit:
expand_ratio = 5;
xrange (:,1) = xrange (:,1) - (xrange(:,2)-xrange(:,1))./expand_ratio;
xrange (:,2) = xrange (:,2) + (xrange(:,2)-xrange(:,1))./expand_ratio;

% a: grid square size.
a = (xrange(:,2)-xrange(:,1)) / resolution;
% grid_step = a / resolution_grid;

grid_boxes  = ceil((xrange(:,2)-xrange(:,1)) ./a);
if resolution == 1;
  grid_boxes = grid_boxes *0 + 1;
end;

xrange(:,2) = xrange(:,1) + grid_boxes .* a; %resolution_grid .* grid_step;


grid_pts = [];
for z_now=xrange(3,1):a(3):xrange(3,2)-a(3)
  for y_now=xrange(2,1):a(2):xrange(2,2)-a(2)
    for x_now=xrange(1,1):a(1):xrange(1,2)-a(1)
    
      pt0 = [x_now, y_now, z_now];
      pt1 = [x_now+a(1),y_now+a(2),z_now+a(3)];
      
      grid_box_now = cplot_2d_gen1box (pt0,pt1,resolution_grid);
      [n1,jnk]     = size(grid_box_now);
 
      grid_pts = [grid_pts; grid_box_now; [NaN NaN NaN]]; % put NaN to seperate boxes.
      % grid_pts = [grid_pts; grid_box_now]; 
    end;
  end;
end;

if resolution == 1; % special case.
  z_now=xrange(3,1);
  y_now=xrange(2,1);
  x_now=xrange(1,1);
  pt0 = [x_now, y_now, z_now];
  pt1 = [x_now+a(1),y_now+a(2),z_now+a(3)];
  grid_pts = cplot_2d_gen1box (pt0,pt1,resolution_grid);
  [n1,jnk]     = size(grid_pts);
end;

if debug_flag; size(grid_pts), end;

% n1: pts per box.
% ns: x/y/z box #'s.
n1 = n1;
ns = grid_boxes;
