% cnoise_gaussian.m -- add Gaussian noise to pts.
%
% Usage: cnoise_gaussian (point, sigma);
% Parameters:
%     point -- point (x,y)
%     sigma -- Gaussian noise width.
% Returns:
%     newpoint -- point w/ Gaussian noise.
% ------------------------------------------------
% Last modified: 08/02/97 2PM.

function [new_points] = cnoise_gaussian (points, sigma);


[n,m] = size(points);
new_points = points;

% generate Gaussian noise.
% ------------------------

for i=1:n
  v1 = 2*rand(1,1) - 1;
  v2 = 2*rand(1,1) - 1;
  r = v1*v1 + v2*v2;
  
  while r>=1.0
    v1 = rand(1,1);
    v2 = rand(1,1);
    r = v1*v1 + v2*v2;
  end;
  
  fac = sqrt(-2.0*sigma*sigma*log(r)/r);
  
  new_points(i,1) = points(i,1) + v1*fac;
  new_points(i,2) = points(i,2) + v2*fac;
end;


%v1
%v2
%fac




