% cm_threshold.m
% ------------------------------------------------------------------- 
% Threshold a matrix. 
% Change all the entries (larger/smaller) than the threshold to
% a new constant value.
%
% Usage: [im1] = cm_threshold (im, thresh, '>', new_value);
% 
% Other symbols: '<', '>=', '<=', '=='.
%
% Notes: Need to use matrix <--> vector convertion to do this.
% ------------------------------------------------------------------- 
% Last modified: 09/25/00

function [im1] = cm_threshold (im, thresh, comp_symbol, new_value);

% Check input:
if (nargin ~= 4) 
  disp ('# ERROR: cm_threshold -- wrong input !');
  help cm_threshold; break;
end;
  
% Convert the matrix to a vector:
[m,n] = size(im);
tmp   = cim2col (im);

% Do the thresholding:
switch (comp_symbol)
  case '>'
    [ind]    = find (tmp>thresh);
    tmp(ind) = new_value;
  case '>='
    [ind]    = find (tmp>=thresh);
    tmp(ind) = new_value;
  case '<'
    [ind]    = find (tmp<thresh);
    tmp(ind) = new_value;
  case '<='
    [ind]    = find (tmp<=thresh);
    tmp(ind) = new_value;
  case '=='
    [ind]    = find (tmp~=thresh);
    tmp(ind) = new_value;
  otherwise
    disp ('# ERROR: cm_threshold -- wrong comp_symbol');
    help cm_threshold; break;
end;

im1 = ccol2im (tmp, m,n);
    
