%%%%%
% 4 % %%% cMIX_plot_simple %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%
%
% Plot the cMIX progress. (no Cx, just T -- as isotropic covariance).
%
% Usage: 
% [] = cMIX_plot_simple (method, x, y, z, vx, m, m_threshold, T, ...
%    transformation_type, c_tps, d_tps, w, sigma_kernel);
% 
% 02/01/00

function [] = cMIX_plot_simple (method, x, y, z, vx, m, m_threshold, T, ...
    transformation_type, c_tps, d_tps, w, sigma_kernel, m_method);

debug_flag = 1;

% configure:
xmarker = 'go'; xsize = 6;
ymarker = 'r+'; ysize = 6;
zmarker = 'go'; zsize = 6;
inter_marker = 'g+'; 

%link_color  = 'r:';
%link_marker = ':';

% -------------------------------------------------------------------
% Generate 3 windows.
% -------------------------------------------------------------------
[siz1,dim] = size (x);
[siz2,dim] = size (y);
c = c_tps;
d = d_tps;


% --- 2D data --------------------------------------------------------
if (dim == 2)
  
switch (method)
  case 2
    
    h_sub1 = subplot ('position', [0.05 0.6 0.2 0.3]); 
    cplot (x, xmarker, xsize); hold on; 
    cplot (y, ymarker, ysize); 
    axis ('equal'); axis ('off'); title ('Original V and X'); 

    
    h_sub2 = subplot ('position', [0.05 0.1 0.2 0.3]);
    cplot (vx, xmarker, xsize); hold on; 
    cplot (y,  ymarker, ysize); 
    axis ('equal'); axis ('off'); title ('Transformed V + X');

    h_sub3 = subplot ('position', [0.3 0.1 0.4 0.7]);
    cplotg (vx, y, m, m_threshold); hold on; 
    if ~(strcmp(m_method, 'icp'))
      cMIX_plot_mixture_simple (vx,T,'b-'); hold on;
    end;
    cplot (vx, xmarker, xsize); hold on; 
    cplot (y,  ymarker, ysize); hold on; 
    axis ('equal'); axis ('off'); title ('Transformed V + X');
    
    h_sub4 = subplot ('position', [0.75 0.6 0.2 0.3]); 
    switch (transformation_type)
      case 'tps'
	ctps_plot_grid (x, x, c, d); 
	axis('equal'); axis('off');title ('TPS Warping');
      case 'rbf'
	crbf_plot_grid (x,z,w, sigma_kernel); 
	axis('equal'); axis('off');title ('RBF Warping');
	% case 'gtm_tps'
	% cgtm_plot_grid_simple ('tps_style', x,y,z,w, 0); 
	%	axis('equal'); axis('off');title ('GTM Warping');
    end;
    vx2 = [ones(siz1,1), x] * d; vx2 = vx2(:,2:dim+1);
    cplot (y,   ymarker,      ysize); hold on;
    cplot (vx2, inter_marker, xsize); 
    axis('equal'); axis('off'); %title ('TPS Warping');
	
    h_sub5 = subplot ('position', [0.75 0.1 0.2 0.3]);
    vy  = m * y ./  ( (sum(m'))' * ones(1,dim));
    cplot (y,  'r.',         ysize); hold on;
    cplot (vy, ymarker,      xsize); 
    % cplot (x,  xmarker,      xsize); 
    % cplot (vx, inter_marker, xsize); 
    % cplotg(x, vx); 
    axis('equal'); axis('off'); title ('Estimated Shape');

    % [siz1,temp] = size (x);
    % cplot_2g (x, m*y, 0,0,0,1, eye(siz1), m_threshold); 
    % title ('m*y w/	links');
  
  case 0
    
    cplotg (vx, y, m, m_threshold); hold on; 
    cplot  (vx, xmarker, xsize); hold on; 
    cplot  (y,  ymarker, ysize); hold on; 
    cMIX_plot_mixture_simple (vx, T); title ('Transformed V + X');
    
  case 1
    
    h_sub1 = subplot ('position', [0.05 0.6 0.25 0.3]); 
    cplot (x, xmarker, xsize); hold on; 
    cplot (y, ymarker, ysize); 
    axis ('equal'); axis ('off'); title ('Original V and X'); 
    
    h_sub2 = subplot ('position', [0.05 0.1 0.25 0.3]); 
    cplot (vx, xmarker, xsize); hold on; 
    cplot (y, ymarker, ysize); 
    axis ('equal'); axis ('off'); title ('Transformed V + X');
    
    h_sub3 = subplot ('position', [0.35 0.1 0.55 0.7]);
    cplotg (vx, y, m, m_threshold); hold on;
    cMIX_plot_mixture_simple (vx, T); 
    axis ('equal'); axis ('off'); title ('Transformed V + X');


  otherwise;
end;



% --- 3D data --------------------------------------------------------
else 

switch (method)
  
  case 1
    
    set (gcf, 'color', [0 0 0]);
    hold off;
    
    h_sub1 = subplot ('position', [0.05 0.6 0.25 0.3]); hold off;
    cplot (x, xmarker, xsize); hold on; 
    cplot (y, ymarker, ysize); title ('Original V_x and Y'); 
    axis ('equal'); set(gca, 'box', 'on');
    
    h_sub2 = subplot ('position', [0.05 0.1 0.25 0.3]); hold off;
    if debug_flag; disp ('plotting mixture model ...'); end;
    cMIX_plot_mixture_simple (vx(1,:), T); 
    cplot  (vx, xmarker, xsize); hold on; 
    cplot  (y,  ymarker, xsize); hold on;
    % cplotg (vx, y,       m, m_threshold); hold on;
    title ('Transformed V_x + Y'); hold on;
    axis('on'); set(gca, 'box', 'on'); 
   
    h_sub3 = subplot ('position', [0.35 0.1 0.55 0.7]); hold off;
    if debug_flag; disp ('plotting deformation ...'); end;
    switch (transformation_type)
      case 'tps'

	vt = [-18,28];
	
	cplot (y,  ymarker, ysize); hold on;
	cplot (vx, xmarker, xsize); hold on; 
	if debug_flag; disp ('plotting links ...'); end;
	% cplotg (vx, y, m, m_threshold,'y',':'); view(vt); hold on; %,'y',':'); hold on;
	%axis('equal'); axis('off');title ('TPS Warping');

	if debug_flag; disp ('plotting grid ...'); end;
	ctps_plot_grid (x, x, c, d,2,4,1); view(vt); hold on; 

	m_threshold = 3/length(x);
	fig(2); clf;
	subplot (311); yy = [y(:,1),y(:,2)]; xx = [vx(:,1),vx(:,2)];
	cplotg (xx,yy,m,m_threshold); hold on;
	cplot (xx,yy); hold on;

	subplot (312); yy = [y(:,1),y(:,3)]; xx = [vx(:,1),vx(:,3)];
	cplotg (xx,yy,m,m_threshold);hold on;
	cplot (xx,yy); hold on;

	subplot (313); yy = [y(:,2),y(:,3)]; xx = [vx(:,2),vx(:,3)];
	cplotg (xx,yy,m,m_threshold);hold on;
	cplot (xx,yy); hold on;


      case 'gtm_tps'
	cgtm_plot_grid_simple ('tps_style', x,y,z,w, 0); 
	axis('equal'); axis('off');title ('GTM Warping');
      
      case 'gtm_gaussian'
	cgtm_plot_grid_simple ('gaussian_style', x,y,z,w, sigma_kernel); 
	axis('equal'); axis('off');title ('GTM Warping');
      otherwise; disp ('no');
    end;
  
  case 2
    set (gcf, 'color', [0 0 0]);
    hold off;
    
    h_sub1 = subplot ('position', [0.05 0.6 0.2 0.3]); axis ('equal');
    cplot (x, xmarker, xsize); hold on; 
    cplot (y, ymarker, ysize); title ('Original V_x and Y'); 
    set(gca, 'box', 'on');
    
    h_sub2 = subplot ('position', [0.05 0.1 0.2 0.3]);
    cplot (vx, xmarker, xsize); hold on; 
    cplot (y, ymarker, ysize); title ('Transformed V_x + Y');
    set(gca, 'box', 'on'); 

    
    h_sub3 = subplot ('position', [0.3 0.1 0.4 0.7]);
    if debug_flag; disp ('plotting mixture model ...'); end;
    cMIX_plot_mixture_simple (vx(1,:), T); 
    cplot (vx, xmarker, xsize); hold on; 
    cplot (y, ymarker, xsize); hold on;
    cplotg (vx, y, m, m_threshold); hold on;
    title ('Transformed V_x + Y'); hold on;
    axis('on'); set(gca, 'box', 'on'); 
%    view (45, 45);
    
    h_sub4 = subplot ('position', [0.75 0.6 0.2 0.3]); 
    % if mod(it_total,3) == 0     % this is expensive.
    if debug_flag; disp ('plotting deformation ...'); end;
    switch (transformation_type)
      case 'tps'
	ctps_plot_grid (x, x, c, d,2,2);     view (-15,50);
	axis('equal'); axis('off');title ('TPS Warping');
	cplot (y, ymarker, ysize); hold on;
	cplot (vx, xmarker, xsize); hold on; 
      case 'gtm_tps'
	cgtm_plot_grid_simple ('tps_style', x,y,z,w, 0); 
	axis('equal'); axis('off');title ('GTM Warping');
      
      case 'gtm_gaussian'
	cgtm_plot_grid_simple ('gaussian_style', x,y,z,w, sigma_kernel); 
	axis('equal'); axis('off');title ('GTM Warping');
      otherwise; disp ('no');
    end;
	
    h_sub5 = subplot ('position', [0.75 0.1 0.2 0.3]);
    vy       = m * y ./  ( (sum(m'))' * ones(1,dim));
    cplot (y,  'r.', ysize); hold on;
    cplot (vy, ymarker,      xsize); 
    
end;

end;


function [] = temp ();

if sum(sum(c)) ~= 0
  % ctps_plot_grid_simple('', vx1, vy, c,d); axis('equal');
  % axis('off');title ('TPS Warping');
  vx2 = [ones(siz1,1), x] * d; vx2 = vx2(:,2:dim+1);
  ctps_plot_grid_simple ('', x(:,1:2), y(:,1:2), c(:,1:3),d(1:3,1:3)); 
  
  %cplot (vx, 'g+', xsize); hold on;
  cplot (vx, xmarker, ysize); hold on;
  axis('equal'); axis('off');title ('TPS Warping');
end

