
%%%%%
% 1 % %%% cMIX_calc_m %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%
%
% Update m (correspondence).
%
% Usage:
% [m] = cMIX_calc_m (vx, y, T, 'icp');
% [m] = cMIX_calc_m (vx, y, T, 'mixture');
% [m] = cMIX_calc_m (vx, y, T, 'rpm');
%
% Notes: for "icp", set k_sigma = 0 -- no outlier.
%
% 01/31/00

function [m, m_outliers_row, m_outliers_col] = cMIX_calc_m ...
    (vx, y, T, m_method, m_outliers_row, m_outliers_col, it_total, icp_sigma);

[xmax,dim] = size(vx);
[ymax,dim] = size(y);


% ------------------------------------------------------------------ ICP ---
if strcmp (m_method, 'icp')

  k_sigma = icp_sigma;
  [m, dist_threshold] = cMIX_calc_m_ICP (vx, y, k_sigma);
  m = m + randn(xmax, ymax) * (1/xmax) * 0.001; 
  

% ------------------------------------------------------ one way mixture ---  
elseif strcmp (m_method, 'mixture')
	
  % Given v=tranformed(x), update m:
  y_tmp = zeros (xmax, ymax);
  for it_dim=1:dim
    y_tmp = y_tmp + (vx(:,it_dim) * ones(1,ymax) - ones(xmax,1) * y(:,it_dim)').^2;
  end;  
  
  m_tmp = 1/sqrt(T) .* exp (-y_tmp/T); 
  
  % add noise here is wrong !!!.
  % m_tmp = m_tmp + randn(xmax, ymax) * (1/xmax) * 0.001; 
  
  m = m_tmp;
  
  % normalize accross the outliers as well:
  sy         = sum (m) + m_outliers_row;
  sy         = sy + ones(size(sy)) * 1e-10;
  m          = m ./ (ones(xmax,1) * sy); 

  % add a little bit noise.
  m = m + abs(randn(xmax, ymax)) * (1/xmax) * 1e-4; 

  % sx = sum(m')' + m_outliers_col;
  % m2 = m ./ (sx * ones(1,ymax));
  % m = (m+m2)/2;

  
% -------------------------------------------------------- mixture - RPM ---
elseif strcmp (m_method, 'mix-rpm')
	
  % Given v=tranformed(x), update m:
  y_tmp = zeros (xmax, ymax);
  for it_dim=1:dim
    y_tmp = y_tmp + (vx(:,it_dim) * ones(1,ymax) - ones(xmax,1) * y(:,it_dim)').^2;
  end;  
  
  m_tmp = 1/sqrt(T) .* exp (-y_tmp/T); 
  m_tmp = m_tmp + randn(xmax, ymax) * (1/xmax) * 0.001; 
  
  m = m_tmp;

  [m, junk1, junk2] = cMIX_normalize_m (m_tmp, m_outliers_col, m_outliers_row);
  m = m + randn(xmax, ymax) * (1/xmax) * 0.001; 

  % normalize accross the outliers as well:
  %sy         = sum (m) + m_outliers_row;
  %m          = m ./ (ones(xmax,1) * sy); 

  %sx = sum(m')' + m_outliers_col;
  %m2 = m ./ (sx * ones(1,ymax));
  %m = (m+m2)/2;

  
% --------------------------------------------- RPM, double normalization ---
elseif strcmp (m_method, 'rpm')
  % Given v=tranformed(x), update m:
  y_tmp = zeros (xmax, ymax);
  for it_dim=1:dim
    y_tmp = y_tmp + (vx(:,it_dim) * ones(1,ymax) - ones(xmax,1) * y(:,it_dim)').^2;
  end;  
  
  m_tmp = exp (-y_tmp/T); 
  m_tmp = m_tmp + randn(xmax, ymax) * (1/xmax) * 0.001; 
  
  % double normalization, but keep outlier entries constant.
  moutlier       = 1/xmax * 0.1;
  m_outliers_row = ones (1,ymax) * moutlier; 
  m_outliers_col = ones (xmax,1) * moutlier; 
  
  [m, junk1, junk2] = cMIX_normalize_m (m_tmp, m_outliers_col, m_outliers_row);
  
  
% --------------------------------------------- RPM, double normalization ---
elseif strcmp (m_method, 'rpm-old')
  % Given v=tranformed(x), update m:
  y_tmp = zeros (xmax, ymax);
  for it_dim=1:dim
    y_tmp = y_tmp + (vx(:,it_dim) * ones(1,ymax) - ones(xmax,1) * y(:,it_dim)').^2;
  end;  
  
  m_tmp = exp (-y_tmp/T); 
  m_tmp = m_tmp + randn(xmax, ymax) * (1/xmax) * 0.001; 
  
  % double normalization, also update outlier entries.
  if (it_total == 1)
    moutlier       = 1/xmax * 0.1;
    m_outliers_row = ones (1,ymax) * moutlier; 
    m_outliers_col = ones (xmax,1) * moutlier; 
  end;
  [m, m_outliers_row, m_outliers_col] = cMIX_normalize_m (m_tmp, m_outliers_col, m_outliers_row);
  
else	
  disp ('# ERROR #: cMIX_calc_m -- wrong input!');
end
    





