/* Isocontour based density Demo (version 0.0.1):
 ----------------------------------------------------
 Copyright (C) 2008 Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
 
 Authors: Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
 Date:    1st April 2008
 
 Contact Information:

 Ajit Rajwade:	avr@cise.ufl.edu
 Arunava Banerjee: arunava@cise.ufl.edu
 Anand Rangarajan: anand@cise.ufl.edu

 Terms:	  
 
 The source code is provided under the
 terms of the GNU General Public License (version 2).
*/

#include "regim.h"
#define NUMTRIALS 20

int main (int argc, char **argv)
{
	double **im1,**im2;
	double p1_simple[NL],p2_simple[NL],p1_iso[NL],p2_iso[NL];
	FILE *fp;
	int i, j, k,ii;
	char filename[100],filename1[100],filename2[100];
	double **joint_pdf;

//	H = 729; W = 745;

	//printf ("\nEnter the value of k: "); scanf ("%d",&k);
	printf ("\nEnter the value of H and W: "); scanf ("%d %d",&H,&W);

	im1 = allocate_2d_double(H,W,'1');
	im2 = allocate_2d_double(H,W,'1');
	joint_pdf = allocate_2d_double(NL,NL,'1');

	printf ("\nenter filename1: "); scanf ("%s",filename1);
	printf ("\nenter filename2: "); scanf ("%s",filename2);
		
		fp = fopen (filename1,"rb");
		for(i=0;i<H;i++)
		{
			for(j=0;j<W;j++)
			{
				fscanf(fp,"%lf",&im1[i][j]);
			}
		}
		fclose (fp);

		fp = fopen (filename2,"rb");
		for(i=0;i<H;i++)
		{
			for(j=0;j<W;j++)
			{
				fscanf(fp,"%lf",&im2[i][j]);
			}
		}
		fclose (fp);

		////////////////////////////////////////////////////////////////////////////////
		joint_density_isocontours (im1,im2,joint_pdf);
		find_marginals (p1_iso,p2_iso,joint_pdf);

		sprintf (filename,"iso_joint_pdf_%dbins.txt",NL);
		fp = fopen (filename,"w");
		for (i=0;i<NL;i++)
		{
			for (j=0;j<NL;j++)
			{
				fprintf (fp,"%lf ",joint_pdf[i][j]);
			}
			fprintf (fp,"\n");
		}
		fclose (fp);	
		////////////////////////////////////////////////////////////////////////////////

		////////////////////////////////////////////////////////////////////////////////
		joint_density_histograms (im1,im2,joint_pdf);
		find_marginals (p1_simple,p2_simple,joint_pdf);

		sprintf (filename,"simple_joint_pdf_%dbins.txt",NL);
		fp = fopen (filename,"w");
		for (i=0;i<NL;i++)
		{
			for (j=0;j<NL;j++)
			{
				fprintf (fp,"%lf ",joint_pdf[i][j]);
			}
			fprintf (fp,"\n");
		}
		fclose (fp);	
		////////////////////////////////////////////////////////////////////////////////

		sprintf (filename,"iso_marginal_pdf_%dbins.txt",NL);
		fp = fopen (filename,"w");
		for (i=0;i<NL;i++)
			fprintf (fp,"%lf\n",p1_iso[i]);
		fclose (fp);	

		sprintf (filename,"simple_marginal_pdf_%dbins.txt",NL);
		fp = fopen (filename,"w");
		for (i=0;i<NL;i++)
			fprintf (fp,"%lf\n",p1_simple[i]);
		fclose (fp);	

}
