/* Isocontour based density Demo (version 0.0.1):
 ----------------------------------------------------
 Copyright (C) 2008 Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
 
 Authors: Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
 Date:    1st April 2008
 
 Contact Information:

 Ajit Rajwade:	avr@cise.ufl.edu
 Arunava Banerjee: arunava@cise.ufl.edu
 Anand Rangarajan: anand@cise.ufl.edu

 Terms:	  
 
 The source code is provided under the
 terms of the GNU General Public License (version 2)
*/

#include "regim.h"

void joint_pdf_isbi (double **im1, double **im2, double ** joint_pdf)
{
	int i,j,k,kk,ll;
	int f1,f2,f3,f4,f,fl,tempflags[10],tempflags1[10],tempflags2[10];	
	double i1_topleft, i1_topright, i1_bottomleft, i1_bottomright;
	double i2_topleft, i2_topright, i2_bottomleft, i2_bottomright;
	double pairs[NL*NL][2];
	int numpairs,Nout;
	double x1,x2,x3,y1,y2,y3,xint[10],yint[10],xtri[10],ytri[10],xout[10],yout[10],xint_1[10],yint_1[10],xint_2[10],yint_2[10];
	double xint1,yint1,xint2,yint2,xint3,yint3,xint4,yint4;
	double deter,d1,d2;
	double invMat[3][3];
	double a11,b11,c11,a12,b12,c12,a22,b22,c22,a21,b21,c21;
	int ind1,ind2,count,count_1,count_2,nflag;
	double minim1,minim2,maxim1,maxim2,sum,area,pix_area1,pix_area2;
	double extra_x,extra_y;


	for(i=0;i<10;i++)
	{
		xout[i] = 0;
		yout[i] = 0;
	}

	for(i=0;i<NL;i++)
	{
		for(j=0;j<NL;j++)
		{
			joint_pdf[i][j] = 0;
		}
	}

	max_min_image(im1,&minim1,&maxim1);
	max_min_image(im2,&minim2,&maxim2);

	for(i=0;i<H;i++)
	{
		for(j=0;j<W;j++)
		{
			im1[i][j] = floor((NL-1)*(im1[i][j]-minim1)/(maxim1-minim1)); /*im1[i][j] /= (256/NL);*/
			im2[i][j] = floor((NL-1)*(im2[i][j]-minim2)/(maxim2-minim2)); /*im2[i][j] /= (256/NL);*/
		}
	}

	for (i=0;i<H-1;i++)
	{
		for(j=0;j<W-1;j++)
		{
			if (VERBOSE == 1)
			{
				printf ("\n%d %d",i,j); fflush(stdout);
			}

			pix_area1 = 0; pix_area2 = 0; nflag = 0;

			i1_topleft = im1[i][j]; i1_topright = im1[i][j+1]; i1_bottomleft = im1[i+1][j]; i1_bottomright = im1[i+1][j+1];
			i2_topleft = im2[i][j]; i2_topright = im2[i][j+1]; i2_bottomleft = im2[i+1][j]; i2_bottomright = im2[i+1][j+1];	
							
			/* left half-pixel: TL, BL, BR  - create the intensity pairs */
			createPairs2 (pairs,&numpairs,i1_topleft,i1_bottomleft,i1_bottomright,i2_topleft,i2_bottomleft,i2_bottomright);
	
			if (numpairs <= 0) { nflag++; goto upper_pixel;}

			/* topleft: [x1,y1] = [j-0.5,i-0.5];; bottomleft: [x2,y2] = [j-0.5,i+0.5];; bottomright: [x3,y3] = [j+0.5,i+0.5] */
			x1 = x2 = j; y1 = i; y2 = y3 = i+1; x3 = j+1;
			xtri[0] = x1; xtri[1] = x2; xtri[2] = x3;
			ytri[0] = y1; ytri[1] = y2; ytri[2] = y3;

			deter = x1*(y2-y3)+x2*(y3-y1)+x3*(y1-y2);
			invMat[0][0] = (y2-y3)/deter;
			invMat[0][1] = (x3-x2)/deter;
			invMat[0][2] = (x2*y3-y2*x3)/deter;
			invMat[1][0] = (y3-y1)/deter;
			invMat[1][1] = (x1-x3)/deter;
			invMat[1][2] = (x3*y1-x1*y3)/deter;
			invMat[2][0] = (y1-y2)/deter;
			invMat[2][1] = (x2-x1)/deter;
			invMat[2][2] = (x1*y2-y1*x2)/deter;
		
			/* coefficients of the plane for image 1 */
			a11 = i1_topleft*invMat[0][0]+i1_bottomleft*invMat[1][0] + i1_bottomright*invMat[2][0];
			b11 = i1_topleft*invMat[0][1]+i1_bottomleft*invMat[1][1] + i1_bottomright*invMat[2][1];
			c11 = i1_topleft*invMat[0][2]+i1_bottomleft*invMat[1][2] + i1_bottomright*invMat[2][2];

			/* coefficients of the plane for image 2 */
			a12 = i2_topleft*invMat[0][0]+i2_bottomleft*invMat[1][0] + i2_bottomright*invMat[2][0];
			b12 = i2_topleft*invMat[0][1]+i2_bottomleft*invMat[1][1] + i2_bottomright*invMat[2][1];
			c12 = i2_topleft*invMat[0][2]+i2_bottomleft*invMat[1][2] + i2_bottomright*invMat[2][2];

			d1 = a11*b12-b11*a12;

			if (a11 == 0 && b11 == 0) goto upper_pixel;
			if (a12 == 0 && b12 == 0) goto upper_pixel;
			if (d1 != 0)
			{
				for(k=0;k<numpairs;k++)	
				{
					ind1 = pairs[k][0];
					ind2 = pairs[k][1];

					xint1 = (b12*(ind1-c11)-b11*(ind2-c12))/d1;
					yint1 = (-a12*(ind1-c11)+a11*(ind2-c12))/d1;

					xint2 = (b12*(ind1-c11+1)-b11*(ind2-c12))/d1;
					yint2 = (-a12*(ind1-c11+1)+a11*(ind2-c12))/d1;

					xint4 = (b12*(ind1-c11)-b11*(ind2-c12+1))/d1;
					yint4 = (-a12*(ind1-c11)+a11*(ind2-c12+1))/d1;

					xint3 = (b12*(ind1-c11+1)-b11*(ind2-c12+1))/d1;
					yint3 = (-a12*(ind1-c11+1)+a11*(ind2-c12+1))/d1;

					f1 = strictly_insideTri(xint1,yint1,(double)i,(double)j,LEFT);
					f2 = strictly_insideTri(xint2,yint2,(double)i,(double)j,LEFT);
					f3 = strictly_insideTri(xint3,yint3,(double)i,(double)j,LEFT);
					f4 = strictly_insideTri(xint4,yint4,(double)i,(double)j,LEFT);
					f = f1+f2+f3+f4;

					joint_pdf[(int)ind1][(int)ind2] += f;
				}
			}//close else

			// if (numpairs > 0) free_2d_double(pairs,numpairs);
			/************************************************************************************************************************/
			/* now deal with the upper half pixel, i.e. topleft to topright, topright to bottom right, topleft to bottomright */

upper_pixel:
			/* left half-pixel: TL, BL, BR  - create the intensity pairs */
			createPairs2 (pairs, &numpairs,i1_topleft,i1_topright, i1_bottomright, i2_topleft, i2_topright, i2_bottomright);

			if (numpairs <= 0) { nflag++; goto end_pixel;}

			/* topleft: [x1,y1] = [j-0.5,i-0.5];; topright: [x2,y2] = [j+0.5,i-0.5];; bottomright: [x3,y3] = [j+0.5,i+0.5] */
			x1 = j; y1 = y2 = i; y3 = i+1; x2 = x3 = j+1;
			xtri[0] = x1; xtri[1] = x3; xtri[2] = x2;
			ytri[0] = y1; ytri[1] = y3; ytri[2] = y2;

			deter = x1*(y2-y3)+x2*(y3-y1)+x3*(y1-y2);
			invMat[0][0] = (y2-y3)/deter;
			invMat[0][1] = (x3-x2)/deter;
			invMat[0][2] = (x2*y3-y2*x3)/deter;
			invMat[1][0] = (y3-y1)/deter;
			invMat[1][1] = (x1-x3)/deter;
			invMat[1][2] = (x3*y1-x1*y3)/deter;
			invMat[2][0] = (y1-y2)/deter;
			invMat[2][1] = (x2-x1)/deter;
			invMat[2][2] = (x1*y2-y1*x2)/deter;
		
			/* coefficients of the plane for image 1 */
			a21 = i1_topleft*invMat[0][0]+i1_topright*invMat[1][0] + i1_bottomright*invMat[2][0];
			b21 = i1_topleft*invMat[0][1]+i1_topright*invMat[1][1] + i1_bottomright*invMat[2][1];
			c21 = i1_topleft*invMat[0][2]+i1_topright*invMat[1][2] + i1_bottomright*invMat[2][2];

			/* coefficients of the plane for image 2 */
			a22 = i2_topleft*invMat[0][0]+i2_topright*invMat[1][0] + i2_bottomright*invMat[2][0];
			b22 = i2_topleft*invMat[0][1]+i2_topright*invMat[1][1] + i2_bottomright*invMat[2][1];
			c22 = i2_topleft*invMat[0][2]+i2_topright*invMat[1][2] + i2_bottomright*invMat[2][2];

			d2 = a21*b22-b21*a22;

			if (a21 == 0 && b21 == 0) continue;
			if (a22 == 0 && b22 == 0) continue;
				
			/* neither of the pathological cases! */
			if (d2 != 0)
			{
				for(k=0;k<numpairs;k++)	
				{
					ind1 = pairs[k][0];
					ind2 = pairs[k][1];
					xint1 = (b22*(ind1-c21)-b21*(ind2-c22))/d2;
					yint1 = (-a22*(ind1-c21)+a21*(ind2-c22))/d2;
	
					xint2 = (b22*(ind1-c21+1)-b21*(ind2-c22))/d2;
					yint2 = (-a22*(ind1-c21+1)+a21*(ind2-c22))/d2;
	
					xint4 = (b22*(ind1-c21)-b21*(ind2-c22+1))/d2;
					yint4 = (-a22*(ind1-c21)+a21*(ind2-c22+1))/d2;
	
					xint3 = (b22*(ind1-c21+1)-b21*(ind2-c22+1))/d2;
					yint3 = (-a22*(ind1-c21+1)+a21*(ind2-c22+1))/d2;
	
					f1 = strictly_insideTri(xint1,yint1,(double)i,(double)j,RIGHT);
					f2 = strictly_insideTri(xint2,yint2,(double)i,(double)j,RIGHT);
					f3 = strictly_insideTri(xint3,yint3,(double)i,(double)j,RIGHT);
					f4 = strictly_insideTri(xint4,yint4,(double)i,(double)j,RIGHT);
					f = f1+f2+f3+f4;

					joint_pdf[ind1][ind2] += f; 
				}
			}
	
			//if (numpairs > 0) free_2d_double(pairs,numpairs);

end_pixel:	
			if( VERBOSE	== 1)
			{
				printf ("\tpix_area = %f, %f",pix_area1,pix_area2); fflush(stdout);
				printf ("\t Nflag = %d",nflag);
				if ((nflag == 0 && pix_area1 + pix_area2 < 0.5000) || (nflag == 1 && pix_area1 + pix_area2 < 0.2500))
				{
					printf ("\n!!!! [%d %d]",i,j); fflush(stdout);
				}
			}
		} // close for loop for 'j'
	}// close for loop for 'i'


	for(i=0;i<H-1;i++)
	{
		for(j=0;j<W-1;j++)
		{
	//		if (im1[i][j] >= 0 && im2[i][j] >= 0)
	//			joint_pdf[(int)im1[i][j]][(int)im2[i][j]] += 1;
		}
	}

	sum = 0;
	for(i=0;i<NL;i++)
	{
		for(j=0;j<NL;j++)
		{
			sum += joint_pdf[i][j];
		}
	}
	for(i=0;i<NL;i++)
	{
		for(j=0;j<NL;j++)
		{
			joint_pdf[i][j] /= sum;
		}
	}

}

