/* Isocontour based density Demo (version 0.0.1):
 ----------------------------------------------------
 Copyright (C) 2008 Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
 
 Authors: Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
 Date:    1st April 2008
 
 Contact Information:

 Ajit Rajwade:	avr@cise.ufl.edu
 Arunava Banerjee: arunava@cise.ufl.edu
 Anand Rangarajan: anand@cise.ufl.edu

 Terms:	  
 
 The source code is provided under the
 terms of the GNU General Public License (version 2).
*/

#include "regim.h"

double find_hd(double *p1,double *p2, double **p)
{
	int i,j;
	double sum = 0;

	for(i=0;i<NL;i++)
	{
		for(j=0;j<NL;j++)
		{
			sum += fabs(p[i][j]-p1[i]*p2[j]);
		}
	}
	return sum;
}

double find_entropy_1d(double *p1)
{
	double e = 0;
	int i;

	for(i=0;i<NL;i++)
	{
		if (p1[i] > 0)
			e -= p1[i]*log(p1[i]);
	}
	
	return e;
}


double find_entropy_2d(double **p)
{
	double e = 0;
	int i,j;

	for(i=0;i<NL;i++)
	{
		for(j=0;j<NL;j++)
		{
			if (p[i][j] > 0)
				e -= p[i][j]*log(p[i][j]);
		}
	}
	
	return e;
}

double find_entropy_parzen_2d (double **training_samples, double **testing_samples, int Ntrain, int Ntest, double sigma, double **im1, double **im2)
{
	int i,j;
	double sum, entropy = 0;
	double twice_sigma_square = 2*sigma*sigma;
	double dist_x, dist_y;
	int actual_Ntrain = 0, actual_Ntest = 0;
	double zi_1, zi_2, zj_1, zj_2;

	for(i=0;i<Ntest;i++)
	{
		sum = 0;
		actual_Ntrain = 0;

		zi_1 = bilinear_interpolant  (im1,testing_samples[i][0],testing_samples[i][1]);
		zi_2 = bilinear_interpolant  (im2,testing_samples[i][0],testing_samples[i][1]);
		if (zi_1 < 0 || zi_2 < 0) continue;
		actual_Ntest++;

		for(j=0;j<Ntrain;j++)
		{
			zj_1 = bilinear_interpolant  (im1,training_samples[j][0],training_samples[j][1]);
			zj_2 = bilinear_interpolant  (im2,training_samples[j][0],training_samples[j][1]);
			if (zj_1 < 0 || zj_2 < 0) continue;
			actual_Ntrain++;
	
			dist_x = (zj_1-zi_1);
			dist_y = (zj_2-zi_2);
			sum += exp(-(dist_x*dist_x+dist_y*dist_y)/(twice_sigma_square));
		}
		sum /= twice_sigma_square*M_PI;
		sum /= actual_Ntrain;
		sum = log(sum);
		entropy -= sum;
	}
	entropy /= actual_Ntest;

	return entropy;
}


double find_entropy_parzen_1d (double **training_samples, double **testing_samples, int Ntrain, int Ntest, double sigma, double **im1, double **im2)
{
	int i,j;
	double sum, entropy = 0;
	double twice_sigma_square = 2*sigma*sigma, sqrt_two_pi_times_sigma = sqrt(2*M_PI)*sigma;
	double dist_x, dist_y;
	int actual_Ntrain = 0, actual_Ntest = 0;
	double zi_1, zj_1,zi_2,zj_2;

	for(i=0;i<Ntest;i++)
	{
		sum = 0;
		actual_Ntrain = 0;
	
		zi_1 = bilinear_interpolant (im1,testing_samples[i][0],testing_samples[i][1]);
		zi_2 = bilinear_interpolant (im2,testing_samples[i][0],testing_samples[i][1]);
		if (zi_1 < 0 || zi_2 < 0) continue;
		actual_Ntest++;

		for(j=0;j<Ntrain;j++)
		{
			zj_1 = bilinear_interpolant  (im1,training_samples[j][0],training_samples[j][1]);
			zj_2 = bilinear_interpolant  (im2,training_samples[j][0],training_samples[j][1]);
			if (zj_1 < 0 || zj_2 < 0) continue;
			actual_Ntrain++;
			dist_x = (zi_1-zj_1);
			sum += exp(-(dist_x*dist_x)/(twice_sigma_square));
		}

		sum /= sqrt_two_pi_times_sigma;
		sum /= actual_Ntrain;
		sum = log(sum);
		entropy -= sum;
	}
	entropy /= actual_Ntest;

	return entropy;
}

double find_sigma_maximum_likelihood (double **training_samples, double **testing_samples, int Ntrain, int Ntest,double **im1, double **im2,double old_sigma)
{
	double sigma = old_sigma;
	int i,k;
	double gradient, numerator,denominator,f,zi_1,zi_2,zk_1,zk_2,alpha=0.001;
	int iter = 0;

	do
	{
		old_sigma = sigma;
		gradient = 0;
		for(k=0;k<Ntest;k++)
		{
			//zk_1 = im1[testing_samples[k][0]][testing_samples[k][1]];
			//zk_2 = im2[testing_samples[k][0]][testing_samples[k][1]];
			zk_1 = bilinear_interpolant (im1,testing_samples[k][0],testing_samples[k][1]);
			zk_2 = bilinear_interpolant  (im2,testing_samples[k][0],testing_samples[k][1]);

			if (zk_1 < 0 || zk_2 < 0) continue;

			denominator = 0;
			numerator = 0;

			for(i=0;i<Ntrain;i++)
			{
				//zi_1 = im1[training_samples[i][0]][training_samples[i][1]];
				//zi_2 = im2[training_samples[i][0]][training_samples[i][1]];
				zi_1 = bilinear_interpolant  (im1,training_samples[i][0],training_samples[i][1]);
				zi_2 = bilinear_interpolant  (im2,training_samples[i][0],training_samples[i][1]);
				if (zi_1 < 0 || zi_2 < 0) continue;

				f = exp(-((zk_1-zi_1)*(zk_1-zi_1)+(zk_2-zi_2)*(zk_2-zi_2))/(2*sigma*sigma));
				numerator += f*(-2/sigma+((zk_1-zi_1)*(zk_1-zi_1)+(zk_2-zi_2)*(zk_2-zi_2))/(sigma*sigma*sigma));
				denominator += f;
			}
			gradient += numerator/denominator;
			if (isnan(gradient))
				printf ("\ngradient = %lf",gradient);
		}		
		sigma = sigma + alpha*gradient; 

		printf ("\nsigma = %lf, gradient = %lf",sigma,gradient);
		alpha = alpha * 0.99;
		
		if (VERBOSE==1) printf ("\t difference = %f",fabs(sigma-old_sigma));

		iter++;
	}while (fabs(old_sigma-sigma) >= VALUE_FOR_CONVERGENCE && iter < MAX_ITERS_OPTIMIZATION);

	//exit (0);

	return sigma;
}


void generate_samples (int **training_samples, int **testing_samples)
{
	int i,j,count_train=0,count_test=0;

	/* generate training and testing samples for the parzen window */
	for(i=0;i<H;i++)
	{
		for(j=0;j<W;j++)
		{
			if (i%2 == 0 && j%2 == 0)
			{
				training_samples[count_train][0] = i;
				training_samples[count_train++][1] = j;
			}
			else
			{
				testing_samples[count_test][0] = i;
				testing_samples[count_test++][1] = j;
			}
		}
	}
}

void generate_samples_random (double **training_samples, double ** testing_samples, int N)
{
	int i,j,count_train=0,count_test=0;
	double x,y;

	for (i=0;i<N;i++)
	{
		x = (double)(rand())/RAND_MAX; y = (double)(rand())/RAND_MAX;
		x = x*(W-1); y = y*(H-1);
		//printf ("\nx = %lf, y = %lf",x,y);

		if (i%2 == 0)
		{
			training_samples[count_train][0] = x;
			training_samples[count_train++][1] = y;
		}
		else
		{
			testing_samples[count_test][0] = x;
			testing_samples[count_test++][1] = y;
		}
	}
}

double find_sigma_maximum_likelihood_newton (double **training_samples, double **testing_samples, int Ntrain, int Ntest,double **im1, double **im2,double old_sigma)
{
	double sigma = old_sigma;
	int i,k,iter=0;
	double L,gradient, numerator,denominator,f,zi_1,zi_2,zk_1,zk_2,alpha=0.01;
	double t1,t2,tt2,sec_deriv;

	printf ("\nOld sigma = %lf",old_sigma);

	do
	{
		old_sigma = sigma;
		gradient = 0;
		sec_deriv = 0;

		/* find the total likelihood */
		L = 0;
		for (k=0;k<Ntest;k++)
		{
			zk_1 = bilinear_interpolant (im1,testing_samples[k][0],testing_samples[k][1]);
			zk_2 = bilinear_interpolant (im2,testing_samples[k][0],testing_samples[k][1]);
			if (zk_1 < 0 || zk_2 < 0) continue;

			numerator = 0;
			for(i=0;i<Ntrain;i++)
			{
				zi_1 = bilinear_interpolant  (im1,training_samples[i][0],training_samples[i][1]);
				zi_2 = bilinear_interpolant  (im2,training_samples[i][0],training_samples[i][1]);
				if (zi_1 < 0 || zi_2 < 0) continue;
				numerator += exp(-((zk_1-zi_1)*(zk_1-zi_1)+(zk_2-zi_2)*(zk_2-zi_2))/(2*sigma*sigma));
			}
			L += log(numerator);
		}
		L /= Ntest;
		printf ("\nLog likelihood = %lf",L);

		for(k=0;k<Ntest;k++)
		{
			//zk_1 = im1[testing_samples[k][0]][testing_samples[k][1]];
			//zk_2 = im2[testing_samples[k][0]][testing_samples[k][1]];
			zk_1 = bilinear_interpolant (im1,testing_samples[k][0],testing_samples[k][1]);
			zk_2 = bilinear_interpolant (im2,testing_samples[k][0],testing_samples[k][1]);
			if (zk_1 < 0 || zk_2 < 0) continue;

			denominator = 0;
			numerator = 0;
			t1 = t2 = 0;

			for(i=0;i<Ntrain;i++)
			{
				//zi_1 = im1[training_samples[i][0]][training_samples[i][1]];
				//zi_2 = im2[training_samples[i][0]][training_samples[i][1]];
				zi_1 = bilinear_interpolant  (im1,training_samples[i][0],training_samples[i][1]);
				zi_2 = bilinear_interpolant  (im2,training_samples[i][0],training_samples[i][1]);
				if (zi_1 < 0 || zi_2 < 0) continue;

				f = exp(-((zk_1-zi_1)*(zk_1-zi_1)+(zk_2-zi_2)*(zk_2-zi_2))/(2*sigma*sigma));
				tt2 = ((zk_1-zi_1)*(zk_1-zi_1)+(zk_2-zi_2)*(zk_2-zi_2))/(sigma*sigma*sigma);
				numerator += f*(-2/sigma+tt2);
				denominator += f;

				t1 += (2/(sigma*sigma)-3*((zk_1-zi_1)*(zk_1-zi_1)+(zk_2-zi_2)*(zk_2-zi_2))/(sigma*sigma*sigma*sigma))*f + (-2/sigma+tt2)*(-2/sigma+tt2)*f;
				t2 += (-2/sigma+tt2)*f;
			}
			gradient += numerator/denominator;
			sec_deriv += (denominator*t1-t2*t2)/(denominator*denominator);
		}		
		printf ("\nGradient = %lf, second derivative = %f",gradient, sec_deriv);
		sigma = sigma  + alpha*gradient/sec_deriv; 
		printf ("\nsigma = %lf",sigma);

		if (VERBOSE==1) printf ("\t difference = %f",fabs(sigma-old_sigma));
		iter++;
		alpha = alpha*0.9;
	}while (fabs(old_sigma-sigma) >= VALUE_FOR_CONVERGENCE && iter < MAX_ITERS_OPTIMIZATION);

	//exit (0);

	return sigma;
}

double find_sigma_bruteforce (double **training_samples, double **testing_samples, int Ntrain, int Ntest,double **im1, double **im2)
{
	double sigma, MINSIGMA = 0.1, MAXSIGMA = NL/2, SIGMA_STEP;
	int i,k;
	double zi_1,zi_2,zk_1,zk_2;
	double f, L, maxL = -INFINITY*INFINITY, optsigma;

	SIGMA_STEP = (MAXSIGMA-MINSIGMA)/40;
	for (sigma = MINSIGMA; sigma <= MAXSIGMA; sigma += SIGMA_STEP)
	{
		L = 0;
		for(k=0;k<Ntest;k++)
		{
			zk_1 = bilinear_interpolant (im1,testing_samples[k][0],testing_samples[k][1]);
			zk_2 = bilinear_interpolant (im2,testing_samples[k][0],testing_samples[k][1]);

			if (zk_1 < 0 || zk_2 < 0) continue;

			f = 0;
			for(i=0;i<Ntrain;i++)
			{
				zi_1 = bilinear_interpolant  (im1,training_samples[i][0],training_samples[i][1]);
				zi_2 = bilinear_interpolant  (im2,training_samples[i][0],training_samples[i][1]);
				if (zi_1 < 0 || zi_2 < 0) continue;

				f += exp(-((zk_1-zi_1)*(zk_1-zi_1)+(zk_2-zi_2)*(zk_2-zi_2))/(2*sigma*sigma));
			}
			L += log (f/Ntrain);
		}		
		L = L/Ntest;
		printf ("%lf, %lf ",sigma,L); fflush (stdout);

		if (L > maxL)
		{
			maxL = L;
			optsigma = sigma;
		}
		
	}
	return optsigma;
}
