/* Isocontour based density Demo (version 0.0.1):
 ----------------------------------------------------
 Copyright (C) 2008 Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
 
 Authors: Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
 Date:    1st April 2008
 
 Contact Information:

 Ajit Rajwade:	avr@cise.ufl.edu
 Arunava Banerjee: arunava@cise.ufl.edu
 Anand Rangarajan: anand@cise.ufl.edu

 Terms:	  
 
 The source code is provided under the
 terms of the GNU General Public License (version 2).
*/

#include "regim.h"

double polyArea (double *xi, double *yi, int count)
{
	double area = 0;
	int i;
	
	if (count < 3) return 0;

	for(i=0;i<count;i++)
	{
		area += xi[i]*yi[(i+1)%count]-xi[(i+1)%count]*yi[i];
	}
	return 0.5*fabs(area);
}

int intersect(double *ox, double *oy,double sx, double sy, double px, double py,double startx, double starty, double endx, double endy)
{
	double edge_delta_x,edge_delta_y,poly_delta_x,poly_delta_y;
	double m_edge,c_edge,m_poly,c_poly;

	edge_delta_y = endy-starty; edge_delta_x = endx-startx;
	poly_delta_y = py-sy; poly_delta_x = px-sx;

	if (poly_delta_x != 0)
	{
		m_poly = poly_delta_y/poly_delta_x;
		c_poly = py - m_poly*px;
	}
	else
	{
		m_poly = INFINITY;
		c_poly = px;
	}


	if (edge_delta_x != 0)
	{
		m_edge = edge_delta_y/edge_delta_x;
		c_edge = endy - m_edge*endx;
	}
	else
	{
		m_edge = INFINITY;
		c_edge = endx;
	}


	if (m_edge == m_poly)
	{
		*ox = INFINITY; *oy = INFINITY;
		return OUTSIDE;
	}


	if (m_poly == INFINITY)
	{
		*ox = c_poly;
		if (m_poly == 0) *oy = py;
		else *oy = m_edge*(*ox)+c_edge;

		/*if ( ((*ox >= sx && *ox <= px) || (*ox <= sx && *ox >= px)) && ((*oy >= sy && *oy <= py) || (*oy <= sy && *oy >= py))
			 && ((*ox >= endx && *ox <= startx) || (*ox <= endx && *ox >= startx)) && ((*oy >= endy && *oy <= starty) || (*oy <= endy && *oy 				>=starty)) )*/
		if ( ((*ox-sx >= -EPS && *ox-px <= EPS) || (*ox-sx <= EPS && *ox-px >= -EPS)) && ((*oy-sy >= -EPS && *oy-py <= EPS) || (*oy-sy <= EPS && 
		*oy-py >= -EPS)) && ((*ox-endx >= -EPS && *ox-startx <= EPS) || (*ox-endx <= EPS && *ox-startx >= -EPS)) && ((*oy-endy >= -EPS && *oy-starty 			<= EPS) || (*oy-endy <= EPS && *oy-starty >= -EPS)) )			
			return INSIDE;
		else
			return OUTSIDE;
	}

	if (m_edge == INFINITY)
	{
		*ox = c_edge;
		if (m_poly == 0) *oy = py;
		else *oy = m_poly*(*ox)+c_poly;

		/*if ( ((*ox >= sx && *ox <= px) || (*ox <= sx && *ox >= px)) && ((*oy >= sy && *oy <= py) || (*oy <= sy && *oy >= py))
			 && ((*ox >= endx && *ox <= startx) || (*ox <= endx && *ox >= startx)) && ((*oy >= endy && *oy <= starty) || (*oy <= endy && *oy 				>=starty)) )*/
		if ( ((*ox-sx >= -EPS && *ox-px <= EPS) || (*ox-sx <= EPS && *ox-px >= -EPS)) && ((*oy-sy >= -EPS && *oy-py <= EPS) || (*oy-sy <= EPS && 
		*oy-py >= -EPS)) && ((*ox-endx >= -EPS && *ox-startx <= EPS) || (*ox-endx <= EPS && *ox-startx >= -EPS)) && ((*oy-endy >= -EPS && *oy-starty 			<= EPS) || (*oy-endy <= EPS && *oy-starty >= -EPS)) )
			return INSIDE;
		else
			return OUTSIDE;
	}

	*ox = -(c_poly-c_edge)/(m_poly-m_edge);

	if (m_poly == 0) *oy = py;
	else *oy = m_edge*(*ox) + c_edge;

	/*if ( ((*ox >= sx && *ox <= px) || (*ox <= sx && *ox >= px)) && ((*oy >= sy && *oy <= py) || (*oy <= sy && *oy >= py))
		 && ((*ox >= endx && *ox <= startx) || (*ox <= endx && *ox >= startx)) && ((*oy >= endy && *oy <= starty) || (*oy <= endy && *oy 				>=starty)) )*/
	if ( ((*ox-sx >= -EPS && *ox-px <= EPS) || (*ox-sx <= EPS && *ox-px >= -EPS)) && ((*oy-sy >= -EPS && *oy-py <= EPS) || (*oy-sy <= EPS && 
		*oy-py >= -EPS)) && ((*ox-endx >= -EPS && *ox-startx <= EPS) || (*ox-endx <= EPS && *ox-startx >= -EPS)) && ((*oy-endy >= -EPS && *oy-starty 			<= EPS) || (*oy-endy <= EPS && *oy-starty >= -EPS)) )
		return INSIDE;
	else
		return OUTSIDE;
}

int inside (double sx, double sy, double xe1, double ye1, double xe2, double ye2)
{
	double edge_normal_x,edge_normal_y;
	double vec_x, vec_y;

	edge_normal_y = (xe2-xe1);
	edge_normal_x = -(ye2-ye1);

	vec_x = sx-xe2;
	vec_y = sy-ye2;

	if (vec_x*edge_normal_x+vec_y*edge_normal_y <= 0) return INSIDE;
	else return OUTSIDE;
}

void polyClip(double *xin, double *yin, int Nin, double *xtri, double *ytri, int Ntri, double *xout, double *yout, int *Nout)
{
	int i,j;
	int flag = 1,count=0,num_intersect=0;
	double sx,sy,px,py,ix,iy;
	double xin_temp[30],yin_temp[30];
	
	copy(xin_temp,xin,Nin); 
	copy(yin_temp,yin,Nin);

	for(j=0;j<Ntri;j++)
	{
		if (Nin <= 0 || Nin >= 30)
		{
			printf ("\nPANIC!");
			exit (0);
		}

		sx = xin_temp[Nin-1]; sy = yin_temp[Nin-1];
		
		for(i=0;i<Nin;i++)
		{
			px = xin_temp[i]; py = yin_temp[i];

			if (inside(px,py,xtri[j],ytri[j],xtri[(j+1)%Ntri],ytri[(j+1)%Ntri]))
			{
				if (inside(sx,sy,xtri[j],ytri[j],xtri[(j+1)%Ntri],ytri[(j+1)%Ntri]))
				{
					xout[count] = px; 
					yout[count++] = py;
				}
				else
				{
/*
					if (intersect (&ix,&iy,sx,sy,px,py,xtri[j],ytri[j],xtri[(j+1)%Ntri],ytri[(j+1)%Ntri]))
					{
						xout[count] = ix; yout[count++] = iy;
						xout[count] = px; yout[count++] = py;
						num_intersect++;
					}
*/
					intersect (&ix,&iy,sx,sy,px,py,xtri[j],ytri[j],xtri[(j+1)%Ntri],ytri[(j+1)%Ntri]);
					xout[count] = ix; yout[count++] = iy;
					xout[count] = px; yout[count++] = py;
					num_intersect++;
				}
			}
			else if (inside(sx,sy,xtri[j],ytri[j],xtri[(j+1)%Ntri],ytri[(j+1)%Ntri]))
			{
/*
				if (intersect (&ix,&iy,sx,sy,px,py,xtri[j],ytri[j],xtri[(j+1)%Ntri],ytri[(j+1)%Ntri]))
				{
					xout[count] = ix; 
					yout[count++] = iy;			
					num_intersect++;
				}
*/
				intersect (&ix,&iy,sx,sy,px,py,xtri[j],ytri[j],xtri[(j+1)%Ntri],ytri[(j+1)%Ntri]);
				xout[count] = ix; 
				yout[count++] = iy;			
				num_intersect++;
			}

			sx = px; sy = py;
		}

		copy(xin_temp,xout,count); copy(yin_temp,yout,count);
		Nin = count; count = 0;
		*Nout = count;

		if (Nin <= 0) break;
	}

	*Nout = Nin;

}

int insideTri (double xint, double yint, double i, double j, int left_right)
{
	int f;
	
	if (left_right == LEFT)
		f = (xint>=j)&&(xint<=j+1)&&(yint>=i)&&(yint<=i+1)&&((yint-i+1)-(xint-j+1))>=0;
	else
		f = (xint>=j)&&(xint<=j+1)&&(yint>=i)&&(yint<=i+1)&&((yint-i+1)-(xint-j+1))<0;

	return f;
}

int strictly_insideTri (double xint, double yint, double i, double j, int left_right)
{
	int f;
	
	if (left_right == LEFT)
		f = (xint>=j)&&(xint<=j+1)&&(yint>=i)&&(yint<=i+1)&&((yint-i+1)-(xint-j+1))>0;
	else
		f = (xint>=j)&&(xint<=j+1)&&(yint>=i)&&(yint<=i+1)&&((yint-i+1)-(xint-j+1))<0;

	return f;
}



void write_poly (double *xint,double *yint,int count)
{
	FILE *fp;
	int i;

/*	if (count == 0) return;

	fp = fopen ("poly.txt","r");
	if (!fp) fp = fopen ("poly.txt","w");
	else { fclose (fp); fp = fopen ("poly.txt","a"); }


	fprintf (fp,"%d ",count);
	for(i=0;i<count;i++)
	{
		fprintf (fp,"%.5lf %.5lf ",xint[i],yint[i]);
	}
	fprintf (fp,"\n");

	fclose(fp);*/
}
