/* Isocontour based density Demo (version 0.0.1):
 ----------------------------------------------------
 Copyright (C) 2008 Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
 
 Authors: Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
 Date:    1st April 2008
 
 Contact Information:

 Ajit Rajwade:	avr@cise.ufl.edu
 Arunava Banerjee: arunava@cise.ufl.edu
 Anand Rangarajan: anand@cise.ufl.edu

 Terms:	  
 
 The source code is provided under the
 terms of the GNU General Public License (version 2)
*/

#include "regim.h"

void max_min_image(double **im, double *minim, double *maxim)
{
	int i,j;
	
	*minim = INFINITY; *maxim = -INFINITY;
	for(i=0;i<H;i++)
	{
		for(j=0;j<W;j++)
		{
			if (im[i][j] < *minim && im[i][j] >= 0) *minim = im[i][j];
			if (im[i][j] > *maxim) *maxim = im[i][j];
		}
	}
}

void copy_image(double **dest, double **src)
{
	int i,j;

	for(i=0;i<H;i++)
	{
		for(j=0;j<W;j++)
		{
			dest[i][j] = src[i][j];
		}
	}
}

double bilinear_interpolant (double **src, double x, double y)
{
	double U,V,val1,val2,val3,val4;

	V = y - floor(y); U = x - floor(x);

	val1 = src[(int)floor(y)][(int)floor(x)]; 
	val2 = src[(int)floor(y)][(int)ceil(x)]; 
	val4 = src[(int)ceil(y)][(int)ceil(x)]; 
	val3 = src[(int)ceil(y)][(int)floor(x)]; 

	return (((1-U)*(1-V)*val1 + U*(1-V)*val2 + (1-U)*V*val3 + U*V*val4));
}


void image_warp_2d_linear_interp (double **dest, double **src, double R[][2])
{
	int i,j;
	double xc,yc,x,y,U,V,val1,val2,val3,val4;

	xc = W/2; yc = H/2;

	for(i=0;i<H;i++)
	{
		for(j=0;j<W;j++)
		{
			dest[i][j] = -1;
		}
	}

	for(i=0;i<H;i++)
	{
		for(j=0;j<W;j++)
		{
			x = (j-xc)*R[0][0]+(i-yc)*R[1][0];
			y = (j-xc)*R[0][1]+(i-yc)*R[1][1];
			x = x+xc; y = y+yc;

			if (x < 0 || y < 0 || ceil(x) >= W || ceil(y) >= H) continue;

			V = y - floor(y); U = x - floor(x);

			val1 = src[(int)floor(y)][(int)floor(x)]; 
			val2 = src[(int)floor(y)][(int)ceil(x)]; 
			val4 = src[(int)ceil(y)][(int)ceil(x)]; 
			val3 = src[(int)ceil(y)][(int)floor(x)]; 

			dest[i][j] = floor((1-U)*(1-V)*val1 + U*(1-V)*val2 + (1-U)*V*val3 + U*V*val4);
		}
	}
}


double cubic_spline_interpolant (double s, double t, double **im1, int y,int x)
{
	int k,l;
	double Bx[4], By[4], ans = 0;

	Bx[0] = 1-s; Bx[0] = Bx[0]*Bx[0]*Bx[0]/6;
	Bx[1] = (3*s*s*s-6*s*s+4)/6;
	Bx[2] = (-3*s*s*s+3*s*s+3*s+1)/6;
	Bx[3] = s*s*s/6;

	By[0] = 1-t; By[0] = By[0]*By[0]*By[0]/6;
	By[1] = (3*t*t*t-6*t*t+4)/6;
	By[2] = (-3*t*t*t+3*t*t+3*t+1)/6;
	By[3] = t*t*t/6;


	for(k=y-1;k<=y+2;k++)
	{	
		if (k+1 < 0 || k+1 >= H) continue;
		for(l=x-1;l<=x+2;l++)
		{
			if (l+1 < 0 || l+1 >= W) continue;
			if (im1[k+1][l+1] < 0) continue;
			ans += Bx[l+1-x]*By[k+1-y]*im1[k+1][l+1];			
		}
	}

	return ans;
}

void image_warp_2d_cubicspline_interp (double **dest, double **src, double R[][2])
{
	int i,j;
	double xc,yc,x,y,U,V,ans;

	xc = W/2; yc = H/2;

	for(i=0;i<H;i++)
	{
		for(j=0;j<W;j++)
		{
			dest[i][j] = -1;
		}
	}

	for(i=0;i<H;i++)
	{
		for(j=0;j<W;j++)
		{
			x = (j-xc)*R[0][0]+(i-yc)*R[1][0];
			y = (j-xc)*R[0][1]+(i-yc)*R[1][1];
			x = x+xc; y = y+yc;

			if (x < 0 || y < 0 || ceil(x) >= W || ceil(y) >= H) continue;

			V = y - floor(y); U = x - floor(x);

			ans = cubic_spline_interpolant (U,V,src,(int)floor(y),(int)floor(x));
			dest[i][j] = floor(ans);
		}
	}
}

void create_matrix (double R[][2], double angle)
{
	R[0][0] = R[1][1] = cos(angle);
	R[0][1] = sin(angle); R[1][0] = -R[0][1];
}

void create_matrix_affine (double R[][2], double theta, double s, double phi, double t)
{
	double ps = pow(2,s), pt = pow(2,t);

	R[0][0] = ps*(pt*cos(phi)*cos(theta)-sin(phi)*sin(theta)/pt);
	R[0][1] = ps*(-pt*sin(phi)*cos(theta)-sin(theta)*cos(phi)/pt);
	R[1][0] = ps*(pt*cos(phi)*sin(theta)+sin(phi)*cos(theta)/pt);
	R[1][1] = ps*(-pt*sin(phi)*sin(theta)+cos(phi)*cos(theta)/pt);
}

void write_image (double **im, char *filename)
{
	FILE *fp;
	int i,j;

	fp = fopen (filename,"w");

	for(i=0;i<H;i++)
	{
		for(j=0;j<W;j++)
		{
			fprintf(fp,"%lf ",im[i][j]);
		}
		fprintf (fp,"\n");
	}	

	fclose (fp);
}

double **allocate_2d_double(int N,int M,char zero)
{
	int i;
	double **matrix;
	
	matrix=(double**)malloc(N*sizeof(double *));
	if (matrix == NULL)
	{
		printf ("\nMemory allocation failed!");
		fflush (stdout);
		exit (0);
	}

	if(!zero)
	{
		for(i=0;i<N;i++) 
		{
			matrix[i]=(double*)malloc(M*sizeof(double));
			if (matrix[i] == NULL)
			{
				printf ("\nMemory allocation failed!");
				fflush (stdout);
				exit (0);
			}
		}
	}
	else
	{
		for(i=0;i<N;i++) 
		{
			matrix[i]=(double*)calloc(M,sizeof(double));
			if (matrix[i] == NULL)
			{
				printf ("\nMemory allocation failed!");
				fflush (stdout);
				exit (0);
			}
		}
	}
	return(matrix);
}

void free_2d_double(double **a,int N)
{
	int i;
	
	for(i=0;i<N;i++)
	{
		free((void *)a[i]); 
	}
	free((void *)a);
}

double *allocate_1d_double(int N,char zero)
{
	double *arr;
	
	if(!zero)
	{
		arr = (double *)malloc(N*sizeof(double));
	}
	else
	{
		arr = (double *)calloc(N,sizeof(double));
	}

	if (arr == NULL)
	{
		printf ("\nMemory allocation failed!");
		fflush (stdout);
		exit (0);
	}
	return(arr);
}

