%Code for Compact Image Representation/Compression using Sparse Tensor Projections onto Exemplar Orthonormal Bases, (version %0.0.1):
%----------------------------------------------------
% Copyright (C) 2009 Karthik Gurumoorthy, Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
% 
% Authors: Karthik Gurumoorthy, Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
% Date:    19th Nov 2009
% 
% Contact Information:
%
%Karthik Gurumoorthy: ksg@cise.ufl.edu
% Ajit Rajwade:	avr@cise.ufl.edu
% Arunava Banerjee: arunava@cise.ufl.edu
% Anand Rangarajan: anand@cise.ufl.edu
%
% Terms:	  
% 
% The source code is provided under the
% terms of the GNU General Public License (version 2).
%



function Y = multiply(data,U_n,n)
    rows= size(U_n,1);
    dim_data = size(data);
    data_n = getn_folding(data,n);
    S = U_n*data_n;
    IX = [n:length(dim_data) 1:(n-1)];
    rotatedDim = dim_data(IX);
    rotatedDim(1) = rows;
    Z = reshape(S,rotatedDim);
    Y = permute(Z,[3-n+2:3 1:3-n+1]);
end
