%Code for Compact Image Representation/Compression using Sparse Matrix Projections onto Exemplar Orthonormal Bases, (version %0.0.1):
%----------------------------------------------------
% Copyright (C) 2009 Karthik Gurumoorthy, Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
% 
% Authors: Karthik Gurumoorthy, Ajit Rajwade, Arunava Banerjee and Anand Rangarajan
% Date:    19th Nov 2009
% 
% Contact Information:
%
%Karthik Gurumoorthy: ksg@cise.ufl.edu
% Ajit Rajwade:	avr@cise.ufl.edu
% Arunava Banerjee: arunava@cise.ufl.edu
% Anand Rangarajan: anand@cise.ufl.edu
%
% Terms:	  
% 
% The source code is provided under the
% terms of the GNU General Public License (version 2).
%



 function [X,DS,newImgData] = getImageParts(imgName,patchSize)
    imgData = double(imread(imgName));
    [rows cols] = size(imgData);
    newRowSize = floor(rows/patchSize(1))* patchSize(1);
    newColSize = floor(cols/patchSize(2))* patchSize(2);
    newImgData = imresize(imgData,[newRowSize newColSize],'bilinear');
    numRows = newRowSize/patchSize(1);
    numCols = newColSize/patchSize(2);
    numComponents = numRows * numCols;
    X = zeros([patchSize(1) patchSize(2) numComponents]);
    DS = [];
    k = 0;
    for i = 1:numRows
        for j = 1:numCols
            k = k + 1;
            startRow = (i-1)*patchSize(1) + 1;
            endRow =  i*patchSize(1);
            startCol = (j-1)*patchSize(2) + 1;
            endCol = j*patchSize(2);
            X(:,:,k) = newImgData(startRow:endRow,startCol:endCol);
            DS(k).startRow = startRow;
            DS(k).endRow = endRow;
            DS(k).startCol = startCol;
            DS(k).endCol = endCol;
        end
    end
end
    
