#include <iostream.h>
#include <fstream.h>
#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <gl/glut.h>
#include "GLBMP.h"
#include <GL/glui.h>
#include "agviewer.h"	//Used for mouse controls (optional)
#include "texture.h"

//OpenGL Calls
void CheckGLError();
void Idle();

//GLUI Calls
void SetupGLUI();

void LoadTextures();

//Callbacks
void Display();
void HandleMessage(int iMessage);
void Keyboard (unsigned char key, int , int );
void MouseButton(int button, int state, int x, int y);
void MouseMotion(int x, int y);
void Reshape(int width, int height);

GLUI * glui;
int iWindowID, iTextureMode=0, iRepeat=1, iFilterMode=0;
int iWindowWidth, iWindowHeight;
float fTranslate[2];
GLuint iTextureList[3];
CGLBMP image;

void CheckGLError()
{
  	GLenum error;
  	error = glGetError();
  	if (error!=GL_NO_ERROR)
  	{
		cout << "OpenGL reports an error: "<< gluErrorString(error) << endl;
		exit(1);
  	}
}

void LoadTextures()
{
	image.LoadImage("test.jpg");
    glBindTexture( GL_TEXTURE_2D, iTextureList[0]);
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexImage2D(GL_TEXTURE_2D,0,GL_RGBA,image.GetWidth(),image.GetHeight(),0,GL_RGBA,  GL_UNSIGNED_BYTE,image.GetData());
}

void Display()
{
	float fRotation=0;
   	glViewport(0,0,iWindowWidth, iWindowHeight);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(45,640/480.0,0.1,10);//Describes the projection matrix
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	agvViewTransform(); //Use mouse control
	glPushMatrix();
	if (iTextureMode==0)
	{
		glBegin(GL_QUADS);
		glColor4f(0,0,1,1);
		glVertex3f(-0.5,-0.5,0);
		glColor4f(0.8,0.8,0.8,1);
		glVertex3f(0.5,-0.5,0);
		glColor4f(1,1,1,1);
		glVertex3f(0.5,0.5,0);
		glColor4f(0.8,0.8,0.8,1);
		glVertex3f(-0.5,0.5,0);
		glEnd();
	}
	else if (iTextureMode==1)
	{
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glEnable(GL_TEXTURE_2D);
	    glBindTexture( GL_TEXTURE_2D, iTextureList[0]);
		if (iFilterMode==0)
		{
			glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
			glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		}
		else if (iFilterMode==1)
		{
			glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
			glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		}

		glBegin(GL_QUADS);
		float i,j, fStep=1.0/(float)iRepeat;
		for (j=-0.5;j<0.5;j=j+fStep)
			for (i=-0.5;i<0.5;i=i+fStep)
			{
				glTexCoord2f(0,0);
				glColor4f(0,0,1,1);
				glVertex3f(i,j,0);
				glTexCoord2f(1,0);
				glColor4f(0.8,0.8,0.8,1);
				glVertex3f(i+fStep,j,0);
				glTexCoord2f(1,1);
				glColor4f(1,1,1,1);
				glVertex3f(i+fStep, j+fStep,0);
				glTexCoord2f(0,1);
				glColor4f(0.8,0.8,0.8,1);
				glVertex3f(i,j+fStep,0);
			}
		glEnd();
	}
	glPopMatrix();
	glutSwapBuffers();
}


void Idle()
{
    if (glutGetWindow()!=iWindowID)
            glutSetWindow(iWindowID);

    glui->sync_live();
	glutPostRedisplay();
}

void main(int argc, char **argv)
{
	glutInit(&argc, argv);  
	glutInitWindowSize(640,480);
	//GLUT version 3.7 or above if you get a pixel format error, switch to the GLUT version 3.6 line
	//glutInitDisplayString("rgba double depth");
	glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE); //GLUT V3.6
	glutInitWindowPosition (0, 0);
	iWindowID=glutCreateWindow("Basic OpenGL App");

	//SETUP CALLBACKS
	cout << "Setting up callbacks... ";
	glutDisplayFunc(Display);
	glutKeyboardFunc(Keyboard);
	glutMouseFunc(MouseButton);
	glutMotionFunc(MouseMotion);
	glutReshapeFunc(Reshape);
 	glutIdleFunc(Idle);
	cout << "[completed]\n";

	agvInit(0);
	agvSwitchMoveMode(POLAR);

	glGenTextures(3, iTextureList);

	//SETUP MISC GL
    glClearColor(0.0, 0.0, 0.0, 1.0);  // background color (last is alpha)
    glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
    glDepthFunc(GL_LEQUAL);
    glEnable(GL_DEPTH_TEST);
    glShadeModel(GL_SMOOTH);

	//GLUI Init
    SetupGLUI();
	LoadTextures();

	CheckGLError();
	glutMainLoop();
}

void Keyboard (unsigned char key, int , int )
{
	printf("Key = %c\n",key);
	switch(key)
    {
		case 27:
        case 'q':
			exit(1);
			break;
	}
}

void MouseButton(int button, int state, int x, int y)
{
	switch (button) 
	{
		case GLUT_LEFT_BUTTON:
		    break;
		case GLUT_MIDDLE_BUTTON:
		    break;
		case GLUT_RIGHT_BUTTON:
		    break;
	}
}

void MouseMotion(int x, int y)
{
	glutPostRedisplay();
}

void SetupGLUI()
{
	GLUI_Spinner * spinner;
	GLUI_Translation * translation;
 
	cout <<"Setting up GLUI... ";
    glui = GLUI_Master.create_glui("Basic OpenGL GUI",0,650,0);
    glui->add_separator();
    spinner=glui->add_spinner("iRepeat", GLUI_EDITTEXT_INT, &iRepeat);
	translation=glui->add_translation("Move Overlay", GLUI_TRANSLATION_XY, (float *)&fTranslate);
	translation->set_speed(0.01);
	glui->add_separator();
	glui->add_button("No Textures", NO_TEXTURE, HandleMessage);
	glui->add_button("Add Texture", TEXTURE, HandleMessage);
	glui->add_button("Point Sample", NEAREST, HandleMessage);
	glui->add_button("Bilinear Filtering", LINEAR, HandleMessage);
	glui->add_button("Quit", QUIT, HandleMessage);
	cout << "[completed]"<<endl;
}

void HandleMessage(int iMessage)
{
	switch(iMessage)
	{
	case NO_TEXTURE:
			iTextureMode=0;
			break;
	case TEXTURE:
			iTextureMode=1;
			break;
	case NEAREST:
	    glBindTexture( GL_TEXTURE_2D, iTextureList[0]);
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
	    glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA, 128, 128, 0, GL_RGBA, GL_UNSIGNED_BYTE, image.GetData());
		printf("Nearest!\n");
		iFilterMode=0;
		break;
	case LINEAR:
	    glBindTexture( GL_TEXTURE_2D, iTextureList[0]);
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
	    glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA, 128, 128, 0, GL_RGBA, GL_UNSIGNED_BYTE, image.GetData());
		printf("Linear!\n");
		iFilterMode=1;
		break;
	case QUIT:
		exit(1);
		break;
	}
}

void Reshape(int width, int height)
{
	if (glutGetWindow()!=iWindowID)
		glutSetWindow(iWindowID);
	glutReshapeWindow(width, height);
	glViewport(0,0,width,height);
	iWindowHeight=height;
	iWindowWidth=width;
};