#include <GL/glut.h>
#include <GL/glu.h>
#include <GL/gl.h>
#include <GL/glui.h>
#include <iostream.h>
#include <fstream.h>
#include "agviewer.h"	//Used for mouse controls (optional)
#include "texture.h"

//OpenGL Calls
void CheckGLError();
void Idle();

//GLUI Calls
void SetupGLUI();

void DrawAxis();
void LoadTextures();

//Callbacks
void Display();
void HandleMessage(int iMessage);
void Keyboard (unsigned char key, int , int );
void MouseButton(int button, int state, int x, int y);
void MouseMotion(int x, int y);

GLUI * glui;
int iWindowID, iTextureMode=0,iRepeat=1, iFilterMode=0, iMipMapping=0, iBlendMode=0, iOverlay=0, iOverlay2=0;
float fSpinner;
float fTranslate[2];
GLubyte tarheels[128][128][4];
GLubyte ice[128][128][4];
GLubyte overlay[128][128][4];
GLuint iTextureList[3];

void CheckGLError()
{
  	GLenum error;
  	error = glGetError();
  	if (error!=GL_NO_ERROR)
  	{
		cout << "OpenGL reports an error: "<< gluErrorString(error) << endl;
		exit(1);
  	}
}

void LoadTextures()
{
	int x,y;
	ifstream in;
	int red, green, blue;
	char line[80];

	in.open("brick.ppm");
	in >> line;
	in >> line;
	in >> line;
	in >> line;

	for (y=0;y<128;y++)
	{
		for (x=0;x<128;x++)
		{
		  in >> red >> green >> blue;
		  tarheels[y][x][0]=red;
		  tarheels[y][x][1]=green;
		  tarheels[y][x][2]=blue;
		  tarheels[y][x][3]=255;
		}
	}
	in.close();
    glBindTexture( GL_TEXTURE_2D, iTextureList[0]);
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
    glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA, 128, 128, 0, GL_RGBA, GL_UNSIGNED_BYTE, tarheels);

	in.open("ice.ppm");
	in >> line;
	in >> line;
	in >> line;
	in >> line;

	for (y=0;y<128;y++)
	{
		for (x=0;x<128;x++)
		{
		  in >> red >> green >> blue;
		  ice[y][x][0]=red;
		  ice[y][x][1]=green;
		  ice[y][x][2]=blue;
		  ice[y][x][3]=255-green;
		}
	}
	in.close();
    glBindTexture( GL_TEXTURE_2D, iTextureList[1]);
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
    glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA, 128, 128, 0, GL_RGBA, GL_UNSIGNED_BYTE, ice);

	in.open("light.ppm");
	//in.open("overlay.ppm");
	//in.open("overlay2.ppm");
	in >> line;
	in >> line;
	in >> line;
	in >> line;

	for (y=127;y>0;y--)
	{
		for (x=0;x<128;x++)
		{
		  in >> red >> green >> blue;
		  overlay[y][x][0]=red;
		  overlay[y][x][1]=red;
		  overlay[y][x][2]=red;
		  overlay[y][x][3]=255-red;
		}
	}
	in.close();
    glBindTexture( GL_TEXTURE_2D, iTextureList[2]);
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
    glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA, 128, 128, 0, GL_RGBA, GL_UNSIGNED_BYTE, overlay);

}

void Display()
{
	float fRotation=0;
   	glViewport(0,0,640,480);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(45,640/480.0,0.1,10);//Describes the projection matrix
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
//	gluLookAt(0,0,2,0,0,0,0,1,0); //
	agvViewTransform(); //Use mouse control
	//DrawAxis();
	glPushMatrix();
	if (iTextureMode==0)
	{
		glBegin(GL_QUADS);
		glColor4f(0,0,1,1);
		glVertex3f(-0.5,-0.5,0);
		glColor4f(0.8,0.8,0.8,1);
		glVertex3f(0.5,-0.5,0);
		glColor4f(1,1,1,1);
		glVertex3f(0.5,0.5,0);
		glColor4f(0.8,0.8,0.8,1);
		glVertex3f(-0.5,0.5,0);
		glEnd();
	}
	else if (iTextureMode==1)
	{
		if (iBlendMode==0)
			glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		else if (iBlendMode==1)
			glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
		glEnable(GL_TEXTURE_2D);
//	    glBindTexture( GL_TEXTURE_2D, iTextureList[0]);
		if (iFilterMode==0)
		{
			glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
			glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		}
		else if (iFilterMode==1)
		{
			glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
			glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
		}

		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
		if (iMipMapping==0)
			glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA, 128, 128, 0, GL_RGBA, GL_UNSIGNED_BYTE, tarheels);
		else if (iMipMapping==1)
		{
			glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
			glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_LINEAR);
			gluBuild2DMipmaps( GL_TEXTURE_2D, GL_RGBA, 128, 128, GL_RGBA, GL_UNSIGNED_BYTE, tarheels);
		}
		/*
		glBegin(GL_QUADS);
		glTexCoord2f(0,0);
		glColor4f(0,0,1,1);
		glVertex3f(-0.5,-0.5,0);
		glTexCoord2f(iRepeat,0);
		glColor4f(0.8,0.8,0.8,1);
		glVertex3f(0.5,-0.5,0);
		glTexCoord2f(iRepeat,iRepeat);
		glColor4f(1,1,1,1);
		glVertex3f(0.5,0.5,0);
		glTexCoord2f(0,iRepeat);
		glColor4f(0.8,0.8,0.8,1);
		glVertex3f(-0.5,0.5,0);
		glEnd();
		*/
		glBegin(GL_QUADS);
		float i,j, fStep=1.0/(float)iRepeat;
		for (j=-0.5;j<0.5;j=j+fStep)
			for (i=-0.5;i<0.5;i=i+fStep)
			{
				glTexCoord2f(0,0);
				glColor4f(0,0,1,1);
				glVertex3f(i,j,0);
				glTexCoord2f(1,0);
				glColor4f(0.8,0.8,0.8,1);
				glVertex3f(i+fStep,j,0);
				glTexCoord2f(1,1);
				glColor4f(1,1,1,1);
				glVertex3f(i+fStep, j+fStep,0);
				glTexCoord2f(0,1);
				glColor4f(0.8,0.8,0.8,1);
				glVertex3f(i,j+fStep,0);
			}
			glEnd();
		if (iOverlay || iOverlay2)
		{
			glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
			glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
			glEnable(GL_BLEND);
			if (iOverlay)
				glBlendFunc(GL_ONE_MINUS_SRC_ALPHA, GL_SRC_ALPHA);
			else
				glBlendFunc(GL_SRC_ALPHA, GL_ZERO);
			glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
			glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA, 128, 128, 0, GL_RGBA, GL_UNSIGNED_BYTE, overlay);
			glBegin(GL_QUADS);
			printf("Translate = %f, %f\n",fTranslate[0], fTranslate[1]);
			glTexCoord2f(fTranslate[0],fTranslate[1]);
			glColor4f(0,0,1,1);
			glVertex3f(-0.5,-0.5,0);
			glTexCoord2f(1+fTranslate[0],fTranslate[1]);
			glColor4f(0.8,0.8,0.8,1);
			glVertex3f(0.5,-0.5,0);
			glTexCoord2f(1+fTranslate[0],1+fTranslate[1]);
			glColor4f(1,1,1,1);
			glVertex3f(0.5,0.5,0);
			glTexCoord2f(fTranslate[0],1+fTranslate[1]);
			glColor4f(0.8,0.8,0.8,1);
			glVertex3f(-0.5,0.5,0);
			glEnd();
			glDisable(GL_BLEND);
		}
		glDisable(GL_TEXTURE_2D);
	}
	else if (iTextureMode==2)
	{
		glEnable(GL_TEXTURE_2D);
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
		glDisable(GL_DEPTH_TEST);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	    glBindTexture( GL_TEXTURE_2D, iTextureList[0]);
		glBegin(GL_TRIANGLES);
		glTexCoord2f(0,1);
		glColor4f(0,0,1,1);
		glVertex3f(-0.5,-0.5,0);
		glTexCoord2f(1,1);
		glColor4f(0.8,0.8,0.8,1);
		glVertex3f(0.5,-0.5,0);
		glTexCoord2f(0.5,0);
		glColor4f(1,1,1,1);
		glVertex3f(0,0.5,0);
		glEnd();
		glBindTexture( GL_TEXTURE_2D, iTextureList[1]);
		glBegin(GL_TRIANGLES);
		glTexCoord2f(0,2);
		glColor4f(1,0,0,1);
		glVertex3f(-0.5,-0.5,0);
		glTexCoord2f(2,2);
		glColor4f(0,1,0,1);
		glVertex3f(0.5,-0.5,0);
		glTexCoord2f(1,0);
		glColor4f(0,0,1,1);
		glVertex3f(0,0.5,0);
		glEnd();

		glEnable(GL_DEPTH_TEST);
		glDisable(GL_BLEND);
		glDisable(GL_TEXTURE_2D);
	}
	glPopMatrix();
	glutSwapBuffers();
}

void DrawAxis()
{
        glBegin(GL_LINES);
		glColor4f(1,0,0,1);
		glVertex3f(5,0,0);
		glVertex3f(0,0,0);
		glColor4f(0,1,0,1);
		glVertex3f(0,5,0);
		glVertex3f(0,0,0);
		glColor4f(0,0,1,1);
		glVertex3f(0,0,5);
		glVertex3f(0,0,0);
		glEnd();
}

void Idle()
{
    if (glutGetWindow()!=iWindowID)
            glutSetWindow(iWindowID);

    glui->sync_live();
	glutPostRedisplay();
}

void main(int argc, char **argv)
{
	glutInit(&argc, argv);  
	glutInitWindowSize(640,480);
	//GLUT version 3.7 or above if you get a pixel format error, switch to the GLUT version 3.6 line
	//glutInitDisplayString("rgba double depth");
	glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE); //GLUT V3.6
	glutInitWindowPosition (0, 0);
	iWindowID=glutCreateWindow("Basic OpenGL App");

	//SETUP CALLBACKS
	cout << "Setting up callbacks... ";
	glutDisplayFunc(Display);
	glutKeyboardFunc(Keyboard);
	glutMouseFunc(MouseButton);
	glutMotionFunc(MouseMotion);
 	glutIdleFunc(Idle);
	cout << "[completed]\n";

	agvInit(0);
	agvSwitchMoveMode(POLAR);

	glGenTextures(3, iTextureList);

	//SETUP MISC GL
    glClearColor(0.0, 0.0, 0.0, 1.0);  // background color (last is alpha)
    //glCullFace(GL_BACK);
    //glEnable(GL_CULL_FACE);		//Enable for backface culling
    glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
    glDepthFunc(GL_LEQUAL);
    glEnable(GL_DEPTH_TEST);
    //glEnable(GL_BLEND);  //Enable if you want to blend (use alpha) when rendering
    glShadeModel(GL_SMOOTH);

	//GLUI Init
    SetupGLUI();
	LoadTextures();

	CheckGLError();
	glutMainLoop();
}

void Keyboard (unsigned char key, int , int )
{
	printf("Key = %c\n",key);
	switch(key)
    {
		case 27:
        case 'q':
			exit(1);
			break;
	}
}

void MouseButton(int button, int state, int x, int y)
{
	switch (button) 
	{
		case GLUT_LEFT_BUTTON:
		    break;
		case GLUT_MIDDLE_BUTTON:
		    break;
		case GLUT_RIGHT_BUTTON:
		    break;
	}
}

void MouseMotion(int x, int y)
{
	glutPostRedisplay();
}

void SetupGLUI()
{
	GLUI_Spinner * spinner;
	GLUI_Translation * translation;
 
	cout <<"Setting up GLUI... ";
    glui = GLUI_Master.create_glui("Basic OpenGL GUI",0,650,0);
    glui->add_separator();
    spinner=glui->add_spinner("Spinner", GLUI_EDITTEXT_FLOAT, &fSpinner);
	spinner->set_speed(10);
    spinner=glui->add_spinner("iRepeat", GLUI_EDITTEXT_INT, &iRepeat);
	translation=glui->add_translation("Move Overlay", GLUI_TRANSLATION_XY, (float *)&fTranslate);
	translation->set_speed(0.01);
	glui->add_separator();
	glui->add_button("No Textures", NO_TEXTURE, HandleMessage);
	glui->add_button("Add Tar Heel Texture", SINGLEPASS, HandleMessage);
	glui->add_button("Multipass", MULTIPASS, HandleMessage);
	glui->add_button("Point Sample", NEAREST, HandleMessage);
	glui->add_button("Bilinear Filtering", LINEAR, HandleMessage);
	glui->add_checkbox("Overlay", &iOverlay);
	glui->add_checkbox("Overlay Type 2", &iOverlay2);
	glui->add_checkbox("MipMapping", &iMipMapping);
	glui->add_checkbox("Blending", &iBlendMode);
	glui->add_button("Quit", QUIT, HandleMessage);
	cout << "[completed]"<<endl;
}

void HandleMessage(int iMessage)
{
	switch(iMessage)
	{
	case NO_TEXTURE:
			iTextureMode=0;
			break;
	case SINGLEPASS:
			iTextureMode=1;
			break;
	case MULTIPASS:
			iTextureMode=2;
			break;
	case NEAREST:
	    glBindTexture( GL_TEXTURE_2D, iTextureList[0]);
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
	    glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA, 128, 128, 0, GL_RGBA, GL_UNSIGNED_BYTE, tarheels);
		printf("Nearest!\n");
		iFilterMode=0;
		break;
	case LINEAR:
	    glBindTexture( GL_TEXTURE_2D, iTextureList[0]);
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
		glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
	    glTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA, 128, 128, 0, GL_RGBA, GL_UNSIGNED_BYTE, tarheels);
		printf("Linear!\n");
		iFilterMode=1;
		break;
	case QUIT:
		exit(1);
		break;
	}
}