#include <GL/glut.h>
#include <GL/glu.h>
#include <GL/gl.h>
#include <GL/glui.h>
#include <iostream.h>
#include <fstream.h>
#include "agviewer.h"	//Used for mouse controls (optional)
#include "ls.h"

//OpenGL Calls
void CheckGLError();
void Idle();

void Light();

//GLUI Calls
void SetupGLUI();

void DrawAxis();
void LoadTextures();

//Callbacks
void Display();
void HandleMessage(int iMessage);
void Keyboard (unsigned char key, int , int );
void MouseButton(int button, int state, int x, int y);
void MouseMotion(int x, int y);

GLUI * glui;
int iWindowID, iTextureMode=0;
int iLit, iShading;
int iTesselation;
float fLightAmbient[3];
float fLightDiffuse[3];
float fLightSpecular[3];
float fMaterialAmbient[3];
float fMaterialDiffuse[3];
float fMaterialSpecular[3];
int iShininess;
float fLightPosition[3];
float fSpotDirection[3];
float fAttenuation[2];
float fSpotAngle;
float fAtten[3];

void CheckGLError()
{
  	GLenum error;
  	error = glGetError();
  	if (error!=GL_NO_ERROR)
  	{
		cout << "OpenGL reports an error: "<< gluErrorString(error) << endl;
		exit(1);
  	}
}

void Display()
{
   	glViewport(0,0,640,480);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(45,640/480.0,0.1,10);//Describes the projection matrix
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
//	gluLookAt(0,0,2,0,0,0,0,1,0); //
	agvViewTransform(); //Use mouse control
	glEnable(GL_DEPTH_TEST);
	DrawAxis();
	GLUquadric * quad;
	quad=gluNewQuadric();
	if (iLit)
	{
		Light();
	}
	glColor4f(1,1,1,1);
	gluSphere(quad,0.5, iTesselation,iTesselation);
	glPushMatrix();
	glTranslatef(1.5,0,0);
	gluSphere(quad,0.3, iTesselation,iTesselation);
	glPopMatrix();
	glPushMatrix();
	glTranslatef(-1.5,0,0);
	gluSphere(quad,0.3, iTesselation,iTesselation);
	glPopMatrix();
	glPushMatrix();
	glTranslatef(0,1.5,0);
	gluSphere(quad,0.3, iTesselation,iTesselation);
	glPopMatrix();
	glPushMatrix();
	glTranslatef(0,-1.5,0);
	gluSphere(quad,0.3, iTesselation,iTesselation);
	glPopMatrix();
	float i, j;
	float size;
	size=2/(float)iTesselation;
	for (j=-1;j<1;j=j+size)
		for (i=-1;i<1;i=i+size)
		{
			glBegin(GL_QUADS);
			glNormal3f(0,0,1);
			glVertex3f(i,j,-1);
			glVertex3f(i+size,j,-1);
			glVertex3f(i+size,j+size,-1);
			glVertex3f(i,j+size,-1);
			glEnd();
		}
	glDisable(GL_LIGHTING);
	glPushMatrix();
	glTranslatef(fLightPosition[0],fLightPosition[1],fLightPosition[2]);
	glutSolidSphere(0.1,12,12);
	glPopMatrix();
	glutSwapBuffers();
}

void Light()
{
	if (iShading)
		glShadeModel(GL_SMOOTH);
	else 
		glShadeModel(GL_FLAT);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	glLightfv(GL_LIGHT0,GL_POSITION,fLightPosition);
	glLightfv(GL_LIGHT0, GL_SPOT_DIRECTION, fSpotDirection);
	glLightfv(GL_LIGHT0, GL_AMBIENT, fLightAmbient);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, fLightDiffuse);
	glLightfv(GL_LIGHT0, GL_SPECULAR, fLightSpecular);
	glLightf(GL_LIGHT0, GL_SPOT_CUTOFF, fSpotAngle);
	glLightf(GL_LIGHT0, GL_CONSTANT_ATTENUATION, fAtten[0]);
	glLightf(GL_LIGHT0, GL_LINEAR_ATTENUATION, fAtten[1]);
	glLightf(GL_LIGHT0, GL_QUADRATIC_ATTENUATION, fAtten[2]);
	glMaterialfv(GL_FRONT,GL_AMBIENT, fMaterialAmbient);
	glMaterialfv(GL_FRONT,GL_DIFFUSE, fMaterialDiffuse);
	glMaterialfv(GL_FRONT,GL_SPECULAR, fMaterialSpecular);
	glMateriali(GL_FRONT,GL_SHININESS, iShininess);
}

void DrawAxis()
{
        glBegin(GL_LINES);
		glColor4f(1,0,0,1);
		glVertex3f(5,0,0);
		glVertex3f(0,0,0);
		glColor4f(0,1,0,1);
		glVertex3f(0,5,0);
		glVertex3f(0,0,0);
		glColor4f(0,0,1,1);
		glVertex3f(0,0,5);
		glVertex3f(0,0,0);
		glEnd();
}

void Idle()
{
    if (glutGetWindow()!=iWindowID)
            glutSetWindow(iWindowID);

    glui->sync_live();
	glutPostRedisplay();
}

void main(int argc, char **argv)
{
	fLightAmbient[0]=0.2;	fLightAmbient[1]=0.2;	fLightAmbient[2]=0.2;
	fLightDiffuse[0]=0.8;	fLightDiffuse[1]=0.8;	fLightDiffuse[2]=0.8;
	fLightSpecular[0]=0.4;	fLightSpecular[1]=0.4;	fLightSpecular[2]=0.4;
	fMaterialAmbient[0]=0.2;	fMaterialAmbient[1]=0.2;	fMaterialAmbient[2]=0.2;
	fMaterialDiffuse[0]=0.8;	fMaterialDiffuse[1]=0.8;	fMaterialDiffuse[2]=0.8;
	fMaterialSpecular[0]=0.4;	fMaterialSpecular[1]=0.4;	fMaterialSpecular[2]=0.4;
	fLightPosition[0]=0;	fLightPosition[1]=0;	fLightPosition[2]=1;
	fSpotDirection[0]=0;	fSpotDirection[1]=0;	fSpotDirection[2]=-1;
	iShininess=4;
	fSpotAngle=180;
	iTesselation=12;
	fAtten[0]=0.1; fAtten[1]=0.1; fAtten[2]=0.15;
	glutInit(&argc, argv);  
	glutInitWindowSize(640,480);
	//GLUT version 3.7 or above if you get a pixel format error, switch to the GLUT version 3.6 line
	glutInitDisplayString("rgb double depth");
	//glutInitDisplay(GLUT_RGBA | GLUT_DOUBLE"); //GLUT V3.6
	glutInitWindowPosition (0, 0);
	iWindowID=glutCreateWindow("Basic OpenGL App");

	//SETUP CALLBACKS
	cout << "Setting up callbacks... ";
	glutDisplayFunc(Display);
	glutKeyboardFunc(Keyboard);
	glutMouseFunc(MouseButton);
	glutMotionFunc(MouseMotion);
 	glutIdleFunc(Idle);
	cout << "[completed]\n";

	agvInit(0);
	agvSwitchMoveMode(POLAR);

	//SETUP MISC GL
    glClearColor(0.0, 0.0, 0.0, 1.0);  // background color (last is alpha)
    //glCullFace(GL_BACK);
    //glEnable(GL_CULL_FACE);		//Enable for backface culling
    glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
    glDepthFunc(GL_LESS);
    glEnable(GL_DEPTH_TEST);
    //glEnable(GL_BLEND);  //Enable if you want to blend (use alpha) when rendering
    glShadeModel(GL_SMOOTH);

	//GLUI Init
    SetupGLUI();

	CheckGLError();
	glutMainLoop();
}

void Keyboard (unsigned char key, int , int )
{
	printf("Key = %c\n",key);
	switch(key)
    {
		case 27:
        case 'q':
			exit(1);
			break;
	}
}

void MouseButton(int button, int state, int x, int y)
{
	switch (button) 
	{
		case GLUT_LEFT_BUTTON:
		    break;
		case GLUT_MIDDLE_BUTTON:
		    break;
		case GLUT_RIGHT_BUTTON:
		    break;
	}
}

void MouseMotion(int x, int y)
{
	glutPostRedisplay();
}

void SetupGLUI()
{
	GLUI_Spinner * spinner;
	GLUI_Translation * translation;
 
	cout <<"Setting up GLUI... ";
    glui = GLUI_Master.create_glui("Basic OpenGL GUI",0,650,0);
    glui->add_separator();
//    spinner=glui->add_spinner("Distance", GLUI_EDITTEXT_FLOAT, &fDistance);
//	spinner->set_speed(10);

    spinner=glui->add_spinner("L Ambient R", GLUI_EDITTEXT_FLOAT, &fLightAmbient[0]);
    spinner=glui->add_spinner("L Ambient G", GLUI_EDITTEXT_FLOAT, &fLightAmbient[1]);
    spinner=glui->add_spinner("L Ambient B", GLUI_EDITTEXT_FLOAT, &fLightAmbient[2]);
	glui->add_separator();
    spinner=glui->add_spinner("L Diffuse R", GLUI_EDITTEXT_FLOAT, &fLightDiffuse[0]);
    spinner=glui->add_spinner("L Diffuse G", GLUI_EDITTEXT_FLOAT, &fLightDiffuse[1]);
    spinner=glui->add_spinner("L Diffuse B", GLUI_EDITTEXT_FLOAT, &fLightDiffuse[2]);
	glui->add_separator();
    spinner=glui->add_spinner("L Specular R", GLUI_EDITTEXT_FLOAT, &fLightSpecular[0]);
    spinner=glui->add_spinner("L Specular G", GLUI_EDITTEXT_FLOAT, &fLightSpecular[1]);
    spinner=glui->add_spinner("L Specular B", GLUI_EDITTEXT_FLOAT, &fLightSpecular[2]);
	glui->add_separator();
	glui->add_column(true);
    spinner=glui->add_spinner("M Ambient R", GLUI_EDITTEXT_FLOAT, &fMaterialAmbient[0]);
    spinner=glui->add_spinner("M Ambient G", GLUI_EDITTEXT_FLOAT, &fMaterialAmbient[1]);
    spinner=glui->add_spinner("M Ambient B", GLUI_EDITTEXT_FLOAT, &fMaterialAmbient[2]);
	glui->add_separator();
    spinner=glui->add_spinner("M Diffuse R", GLUI_EDITTEXT_FLOAT, &fMaterialDiffuse[0]);
    spinner=glui->add_spinner("M Diffuse G", GLUI_EDITTEXT_FLOAT, &fMaterialDiffuse[1]);
    spinner=glui->add_spinner("M Diffuse B", GLUI_EDITTEXT_FLOAT, &fMaterialDiffuse[2]);
	glui->add_separator();
    spinner=glui->add_spinner("M Specular R", GLUI_EDITTEXT_FLOAT, &fMaterialSpecular[0]);
    spinner=glui->add_spinner("M Specular G", GLUI_EDITTEXT_FLOAT, &fMaterialSpecular[1]);
    spinner=glui->add_spinner("M Specular B", GLUI_EDITTEXT_FLOAT, &fMaterialSpecular[2]);
	glui->add_separator();
    spinner=glui->add_spinner("M Shininess", GLUI_EDITTEXT_INT, &iShininess);
	glui->add_column(true);
	translation=glui->add_translation("Light X", GLUI_TRANSLATION_X, (float *)&fLightPosition[0]);
	translation->set_speed(0.01);
	translation=glui->add_translation("Light Y", GLUI_TRANSLATION_Y, (float *)&fLightPosition[1]);
	translation->set_speed(0.01);
	translation=glui->add_translation("Light Z", GLUI_TRANSLATION_Z, (float *)&fLightPosition[2]);
	translation->set_speed(0.01);
	translation=glui->add_translation("Spot Direction X", GLUI_TRANSLATION_X, (float *)&fSpotDirection[0]);
	translation->set_speed(0.01);
	translation=glui->add_translation("Spot Direction Y", GLUI_TRANSLATION_Y, (float *)&fSpotDirection[1]);
	translation->set_speed(0.01);
	translation=glui->add_translation("Spot Direction Z", GLUI_TRANSLATION_Z, (float *)&fSpotDirection[2]);
	translation->set_speed(0.01);
    spinner=glui->add_spinner("SpotAngle", GLUI_EDITTEXT_FLOAT, &fSpotAngle);
    spinner=glui->add_spinner("Constant", GLUI_EDITTEXT_FLOAT, &fAtten[0]);
    spinner=glui->add_spinner("Linear", GLUI_EDITTEXT_FLOAT, &fAtten[1]);
    spinner=glui->add_spinner("Quadratic", GLUI_EDITTEXT_FLOAT, &fAtten[2]);
	glui->add_separator();
	glui->add_checkbox("Toggle Light", &iLit);
	glui->add_checkbox("Toggle Shading", &iShading);
    spinner=glui->add_spinner("Tesselation", GLUI_EDITTEXT_INT, &iTesselation);
	glui->add_button("Quit", QUIT, HandleMessage);
	cout << "[completed]"<<endl;
}

void HandleMessage(int iMessage)
{
	switch(iMessage)
	{
	case NO_TEXTURE:
			iTextureMode=0;
			break;
	case SINGLEPASS:
			iTextureMode=1;
			break;
	case MULTIPASS:
			iTextureMode=2;
			break;
	case QUIT:
		exit(1);
		break;
	}
}