#include <stdlib.h>
#include "glm.h"
#include "glut.h"
#include <stdarg.h>
#include <iostream>
#include <memory.h>
#include <time.h>
#include <fstream>
using namespace std;

GLMmodel *model1,*model2,*model3;
// Default Image dimensions
int imageWidth = 640;
int imageHeight = 480;


//OpenGL Calls
void setupGL();
void CheckGLError();

//Callbacks
void Display();
void Idle();
void Reshape(int w, int h);
void Keyboard (unsigned char key, int , int );
void MouseButton(int button, int state, int x, int y);
void MouseMotion(int x, int y);

//font
GLvoid *font_style = GLUT_BITMAP_HELVETICA_12;

// a cleanup function
void quit(int i = 0);

void main(int argc, char **argv)
{
	// INITIALIZE THE GLUT WINDOW
	glutInit(&argc, argv);  
	glutInitWindowSize(imageWidth, imageHeight);
	glutInitDisplayString("rgb double");
	glutInitWindowPosition(0, 0);
	glutCreateWindow("Project #1");

	//SETUP GLUT CALLBACKS
	cout << "Setting up callbacks... ";
	glutDisplayFunc(Display);
	glutKeyboardFunc(Keyboard);
	glutMouseFunc(MouseButton);
	glutMotionFunc(MouseMotion);
	glutReshapeFunc(Reshape);
	glutIdleFunc(Idle);
	cout << "[completed]\n";
	glEnable(GL_DEPTH_TEST);

	//SETUP MISC GL
	setupGL();

	CheckGLError();
	model1= glmReadOBJ("data/cube.obj");
	model2= glmReadOBJ("data/sphere.obj");
	model3= glmReadOBJ("data/torus.obj");
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	GLfloat light_position[] = { 1.0, 1.0, 1.0, 1.0 };
	GLfloat light_ambient[] = { 0.2, 0.2, 0.2, 1.0 };
	GLfloat light_specular[] = { 0.1, 0.1, 0.1, 1.0 };
	 glLightfv(GL_LIGHT0, GL_POSITION, light_position);
	  glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient);
	  glLightfv(GL_LIGHT0, GL_SPECULAR, light_specular);
	 
	glutMainLoop();
}



// This function checks the state of openGL and prints 
// an error if an error has occurred
void CheckGLError()
{
  	GLenum error;
  	error = glGetError();
  	if (error!=GL_NO_ERROR)
  	{
		cout << "OpenGL reports an error: "<< gluErrorString(error) << endl;
		quit(1);
  	}
}

//drawstr method from Nate Robbins tutorials, 1997
void 
drawstr(GLuint x, GLuint y, char* format, ...)
{
	
    va_list args;
    char buffer[255], *s;
    
    va_start(args, format);
    vsprintf(buffer, format, args);
    va_end(args);
    
    glRasterPos2i(x, y);
    for (s = buffer; *s; s++)
        glutBitmapCharacter(font_style, *s);
}


// This function draws the scene
int angle=0;
void Display()
{

	angle++;
	if(angle>3600)
		angle=0;

	// clear the screen
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	 glMatrixMode(GL_MODELVIEW);
	 glPushMatrix();
	glLoadIdentity();
	gluLookAt(0,0,200,0,0,0,0,1,0);
	glPushMatrix();
	// set the color to white	
		glScalef(.5,.5,.5);
		glTranslatef(0,-5,0);
		//glDisable(GL_LIGHTING);
		glRotatef(angle/10.0,1,0,1);
		/*IF YOU DO NOT EDIT YOUR SCANNED HEAD OBJ,
			THEN DRAW IT LIKE THE FOLLOWING EXAMPLE:glmDraw(model1,GLM_COLOR);*/		
		glmDraw(model1,GLM_COLOR);
	glPopMatrix();
	glPushMatrix();
		glScalef(1,1,1);
		glTranslatef(35,0,0);
		glRotatef(angle/10.0,0,0,1);
		glmDraw(model2, GLM_TEXTURE|GLM_MATERIAL|GLM_SMOOTH);
	glPopMatrix();
	glPushMatrix();
		glScalef(1,1,1);
		glTranslatef(-35,15,0);
		glRotatef(angle/10.0,0,0,1);
		glmDraw(model3,GLM_TEXTURE| GLM_MATERIAL |GLM_SMOOTH);
	glPopMatrix();
	
	//draw text
	glDisable(GL_TEXTURE_2D);
	drawstr(30.0, 20, "x = ");
	drawstr(50.0, 20, "%.1f", 3.0);
	glPopMatrix();
	// swap the buffers
	glutSwapBuffers();
}




// set up GL stuff
void setupGL() {

	// set the clear color
	glClearColor(0.5, 0.5, 0.5, 1.0);  // background color	
}


// This function is continuously called when events are not being received
// by the window.  This is a good place to update the state of your objects 
// after every frame.
void Idle() {
	glutPostRedisplay();

}

// keyboard handler
void Keyboard (unsigned char key, int , int )
{
	switch(key)
    {
		// if esc or q, exit
		case 27:
        case 'q':
			quit(1);
			break;
	}
}

void MouseButton(int button, int state, int x, int y)
{
	switch (button) 
	{
		case GLUT_LEFT_BUTTON:
		    break;
		case GLUT_MIDDLE_BUTTON:
		    break;
		case GLUT_RIGHT_BUTTON:
		    break;
	}
}

void MouseMotion(int x, int y)
{
}

// This functions handles what happens when the window is reshaped
void Reshape(int w, int h) 
{
	imageWidth = w;
	imageHeight = h;

    glViewport(0,0,w,h);
	double aspect = ((double)w) / ((double)h);
	glMatrixMode(GL_PROJECTION);
   	glLoadIdentity();
	gluPerspective(60,aspect,0.01, 10000);
	
   
}

// a cleanup function.  call this when you want to exit.
void quit(int i) 
{
	exit(i);
}