import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.media.opengl.*;
import com.sun.opengl.util.Animator;


/**
   * This is a basic JOGL app. Feel free to
   * reuse this code or modify it.
   */
public class SimpleJoglApp extends JFrame {
	static Animator anim = null;
	SimpleGLEventListener listener;
	
	public static void main(String[] args) {
		final SimpleJoglApp app = new SimpleJoglApp();
 
		// Creates the window in another thread
		SwingUtilities.invokeLater (
				new Runnable() {
					public void run() {
						// Removes the normal title bar. Most games do this.
						//app.setUndecorated(true);
						app.setVisible(true);
						
						// Goes into fullscreen-exclusive mode
						/*GraphicsDevice gd = GraphicsEnvironment.
							getLocalGraphicsEnvironment().getDefaultScreenDevice();
						gd.setFullScreenWindow(app);
						*/
					}
				}
		);
		
		// Starts the Animator in a new thread.
		SwingUtilities.invokeLater (
				new Runnable() {
					public void run() {
						anim.start();
					}
				}
		);
	}
 
	public SimpleJoglApp() {
		// Set the JFrame title
		super("JOGL Application");
		
		// Kill the process when the JFrame is closed
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		GLCapabilities glCaps = new GLCapabilities();
		GLCanvas glCanvas = new GLCanvas(glCaps);
		listener = new SimpleGLEventListener();
		glCanvas.addGLEventListener(listener);
				
		// Add the GLCanvas just like we would any Component
		getContentPane().add(glCanvas, BorderLayout.CENTER);
		setSize(500, 300);
		anim = new Animator(glCanvas);
		glCanvas.requestFocus();
	}
} 