import javax.media.opengl.*;
import javax.media.opengl.glu.*;
import com.sun.opengl.util.*;
import java.awt.event.*;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import JautOGL.*;

public class SimpleGLEventListener implements GLEventListener,KeyListener, MouseListener, MouseMotionListener {
	 GLModel model1;
	 GLModel model2;
	 GLModel model3;
	 int angle=0;
	 int imageWidth;
	 int imageHeight;
		
	// Only put stuff here that should happen once, at the beginning of the program
	public void init(GLAutoDrawable gld) {
		
		gld.addMouseListener(this);
		gld.addKeyListener(this);
		gld.addMouseMotionListener(this);
		
		
		GL gl = gld.getGL();
		GLU glu = new GLU();
		gl.glDisable(GL.GL_BLEND);
		//gl.glClearColor(0.6f, 0.6f, 0.6f, 1.0f);
		gl.glClearColor(0.5f, 0.5f, 0.5f, 1.0f);
		
		gl.glEnable(GL.GL_DEPTH_TEST);
		gl.glEnable(GL.GL_LIGHTING);
		gl.glEnable(GL.GL_LIGHT0);
		gl.glShadeModel(GL.GL_SMOOTH);
		
		//gl.glEnable(GL.GL_COLOR_MATERIAL);
		float light_position[] = { 1.0f, 1.0f, 1.0f, 1.0f };
		float light_ambient[] = { 0.2f, 0.2f, 0.2f, 1.0f};
		float light_diffuse[] = { 1f, 1f, 1f, 1.0f };
		float light_specular[] = { .1f, .1f, .1f, 1.0f };
		 gl.glLightfv(GL.GL_LIGHT0, GL.GL_POSITION, light_position,0);
		 gl.glLightfv(GL.GL_LIGHT0, GL.GL_AMBIENT, light_ambient,0);
		 gl.glLightfv(GL.GL_LIGHT0, GL.GL_DIFFUSE, light_diffuse,0);
		 gl.glLightfv(GL.GL_LIGHT0, GL.GL_SPECULAR, light_specular,0);
		try{	
			// load some objs
			//LOAD YOUR HEAD MODEL JUST LIKE MODEL1 IN THIS EXAMPLE
			//SO YOU SHOULD JUST BE ABLE TO REPLACE 'cube.obj' WITH YOUR HEAD MODEL.
			String path1 = "data/cube.obj";
			String path2 = "data/sphere.obj";
			String path3 = "data/torus.obj";
			//model 1
			
			FileInputStream r_path1 = new FileInputStream(path1);
	        BufferedReader b_read1 =
	             new BufferedReader(new InputStreamReader(r_path1));
	        model1 = new GLModel(b_read1, true, "", gl);
	        r_path1.close();
	        b_read1.close();
	        
	      
	      //model 2
			FileInputStream r_path2 = new FileInputStream(path2);
	        BufferedReader b_read2 =
	             new BufferedReader(new InputStreamReader(r_path2));
	        model2 = new GLModel(b_read2, true, "data/sphere.mtl", gl);
	        r_path2.close();
	        b_read2.close();
	        
	      //model 3
			FileInputStream r_path3 = new FileInputStream(path3);
	        BufferedReader b_read3 =
	             new BufferedReader(new InputStreamReader(r_path3));
	        model3= new GLModel(b_read3, true, "data/torus.mtl", gl);
	        r_path3.close();
	        b_read3.close();
	        
		}
		catch( Exception e ){
            System.out.println("LOADING ERROR" );
            e.printStackTrace();
		}
		
	}
	
	// This function will get called repeatedly by the Animator. Think of it as your game loop.
	public void display(GLAutoDrawable gld) {
		GL gl = gld.getGL();
		GLU glu = new GLU();
		angle++;
		if(angle>3600)
			angle=0;
		gl.glClear(GL.GL_COLOR_BUFFER_BIT | GL.GL_DEPTH_BUFFER_BIT);
		gl.glMatrixMode(GL.GL_MODELVIEW);
		 gl.glPushMatrix();
		gl.glLoadIdentity();
		glu.gluLookAt(0,0,200,0,0,0,0,1,0);
		gl.glPushMatrix();
		 //set the color to white
			gl.glScalef(.8f,.8f,.8f);
			gl.glTranslatef(0f,-5f,0f);
			gl.glRotatef(angle/10.0f,0f,0f,1f);
			
			model1.opengldraw(gl);				
		gl.glPopMatrix();
		gl.glPushMatrix();
			gl.glScalef(1f,1f,1f);
			gl.glTranslatef(35f,0f,0f);
			gl.glRotatef(angle/10.0f,0f,0f,1f);
			
			 	model2.opengldraw(gl);	
		gl.glPopMatrix();
		gl.glPushMatrix();
			gl.glScalef(1f,1f,0.01f);
			gl.glTranslatef(-35f,15f,0f);
			gl.glRotatef(angle/10.0f,0f,0f,1f);
				model3.opengldraw(gl);			
		gl.glPopMatrix();

		//draw text
		gl.glDisable(GL.GL_TEXTURE_2D);
		drawstr(gl,30, 460, "x = ");
		drawstr(gl,50, 460, "3.0");
		gl.glPopMatrix();
	}	
	
	public void drawstr(GL gl, int x, int y, String format)
	{
		GLUT glut = new GLUT();
	    gl.glRasterPos2i(x, y);
		for (int i = 0; i<format.length();i++)
			glut.glutBitmapCharacter(glut.BITMAP_HELVETICA_12, format.charAt(i));
	    
	}
	
	// This function is only called when the window is reshaped. You probably won't need this. 
	public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
		GL gl = drawable.getGL();
		GLU glu = new GLU();
		imageWidth = width;
		imageHeight = height;

	   	gl.glViewport(0,0,width,height);

		gl.glMatrixMode(GL.GL_PROJECTION);
	   	gl.glLoadIdentity();
	   	double aspect = ((double)width) / ((double)height);
	   	glu.gluPerspective(60, aspect, 0.01, 10000);
		
		
	}
	
	// This function is only called when the display settings are changed. Again, not often used.
	public void displayChanged(GLAutoDrawable drawable, boolean a, boolean b) {}
	
	public void keyPressed(KeyEvent event){
		System.out.println("keypress");   
		
	}
	public void keyReleased(KeyEvent event){
		
		System.out.println("keyreleased"); 
	}
	public void keyTyped(KeyEvent event){
		System.out.println("keytyped"); 
	}
	public void mouseClicked(MouseEvent event){
		System.out.println("mouseclick"); 
	}
	public void mouseExited(MouseEvent event){}
	public void mouseEntered(MouseEvent event){}
	public void mouseDragged(MouseEvent event){}
	public void mouseReleased(MouseEvent event){}
	public void mouseMoved(MouseEvent event){}
	public void mousePressed(MouseEvent event){}
} 