import javax.media.opengl.*;
import javax.media.opengl.glu.*;
import com.sun.opengl.util.*;
import java.awt.event.*;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import JautOGL.*;

public class SimpleGLEventListener implements GLEventListener,KeyListener, MouseListener, MouseMotionListener {
	 GLModel model1;
	 GLModel model2;
	 GLModel model3;
	 int angle=0;
	 int imageWidth;
	 int imageHeight;
		
	// Only put stuff here that should happen once, at the beginning of the program
	public void init(GLAutoDrawable gld) {
		GL gl = gld.getGL();
		GLU glu = new GLU();
		gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
		gl.glEnable(GL.GL_DEPTH_TEST);
		try{	
			// load some objs
			String path1 = "data/cube.obj";
			String path2 = "data/sphere.obj";
			String path3 = "data/torus.obj";
			//model 1
			FileInputStream r_path1 = new FileInputStream(path1);
	        BufferedReader b_read1 =
	             new BufferedReader(new InputStreamReader(r_path1));
	        model1 = new GLModel(b_read1, true, "data/cube.mtl", gl);
	        r_path1.close();
	        b_read1.close();
	        
	      //model 2
			FileInputStream r_path2 = new FileInputStream(path2);
	        BufferedReader b_read2 =
	             new BufferedReader(new InputStreamReader(r_path2));
	        model2 = new GLModel(b_read2, true, "data/sphere.mtl", gl);
	        r_path2.close();
	        b_read2.close();
	        
	      //model 3
			FileInputStream r_path3 = new FileInputStream(path3);
	        BufferedReader b_read3 =
	             new BufferedReader(new InputStreamReader(r_path3));
	        model3= new GLModel(b_read3, true, "data/torus.mtl", gl);
	        r_path3.close();
	        b_read3.close();
		}
		catch( Exception e ){
            System.out.println("LOADING ERROR" +  e);
		}
		
	}
	
	// This function will get called repeatedly by the Animator. Think of it as your game loop.
	public void display(GLAutoDrawable gld) {
		GL gl = gld.getGL();
		angle++;
		if(angle>3600)
			angle=0;
		gl.glClear(GL.GL_COLOR_BUFFER_BIT | GL.GL_DEPTH_BUFFER_BIT);
				
		gl.glPushMatrix();
		// set the color to white
			gl.glScalef(10f,10f,0.01f);
			gl.glTranslatef(0f,-5f,0f);
			gl.glRotatef(angle/10.0f,0f,0f,1f);
				model1.opengldraw(gl);				
		gl.glPopMatrix();
		gl.glPushMatrix();
			gl.glScalef(1f,1f,0.01f);
			gl.glTranslatef(15f,15f,0f);
			gl.glRotatef(angle/10.0f,0f,0f,1f);
			 	model2.opengldraw(gl);	
		gl.glPopMatrix();
		gl.glPushMatrix();
			gl.glScalef(1f,1f,0.01f);
			gl.glTranslatef(-35f,15f,0f);
			gl.glRotatef(angle/10.0f,0f,0f,1f);
				model3.opengldraw(gl);			
		gl.glPopMatrix();

		//draw text
		drawstr(gl,30, 460, "x = ");
		drawstr(gl,50, 460, "3.0");
	}	
	
	public void drawstr(GL gl, int x, int y, String format)
	{
		GLUT glut = new GLUT();
	    gl.glRasterPos2i(x, y);
		for (int i = 0; i<format.length();i++)
			glut.glutBitmapCharacter(glut.BITMAP_HELVETICA_12, format.charAt(i));
	    
	}
	
	// This function is only called when the window is reshaped. You probably won't need this. 
	public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
		GL gl = drawable.getGL();
		GLU glu = new GLU();
		imageWidth = width;
		imageHeight = height;

	   	gl.glViewport(0,0,width,height);

		gl.glMatrixMode(GL.GL_PROJECTION);
	   	gl.glLoadIdentity();
		glu.gluOrtho2D(-100,100,-100,100);

	    gl.glMatrixMode(GL.GL_MODELVIEW);
		gl.glLoadIdentity();
		
		
	}
	
	// This function is only called when the display settings are changed. Again, not often used.
	public void displayChanged(GLAutoDrawable drawable, boolean a, boolean b) {}
	
	public void keyPressed(KeyEvent event){}
	public void keyReleased(KeyEvent event){}
	public void keyTyped(KeyEvent event){}
	public void mouseClicked(MouseEvent event){}
	public void mouseExited(MouseEvent event){}
	public void mouseEntered(MouseEvent event){}
	public void mouseDragged(MouseEvent event){}
	public void mouseReleased(MouseEvent event){}
	public void mouseMoved(MouseEvent event){}
	public void mousePressed(MouseEvent event){}
} 