/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLDrawableHelper;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.opengl.AWTGraphicsConfiguration;
import javax.media.opengl.AWTGraphicsDevice;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.Threading;

public class GLCanvas
extends Canvas
implements GLAutoDrawable {
    private static final boolean DEBUG = Debug.debug("GLCanvas");
    private GLDrawableHelper drawableHelper = new GLDrawableHelper();
    private GLDrawable drawable;
    private GLContextImpl context;
    private boolean autoSwapBufferMode = true;
    private boolean sendReshape = false;
    private InitAction initAction = new InitAction();
    private DisplayAction displayAction = new DisplayAction();
    private SwapBuffersAction swapBuffersAction = new SwapBuffersAction();
    private DisplayOnEventDispatchThreadAction displayOnEventDispatchThreadAction = new DisplayOnEventDispatchThreadAction();
    private SwapBuffersOnEventDispatchThreadAction swapBuffersOnEventDispatchThreadAction = new SwapBuffersOnEventDispatchThreadAction();
    private DestroyAction destroyAction = new DestroyAction();
    private static boolean disableBackgroundEraseInitialized;
    private static Method disableBackgroundEraseMethod;
    static /* synthetic */ Class class$java$awt$Canvas;

    public GLCanvas() {
        this((GLCapabilities)null);
    }

    public GLCanvas(GLCapabilities gLCapabilities) {
        this(gLCapabilities, null, null, null);
    }

    public GLCanvas(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext, GraphicsDevice graphicsDevice) {
        super(GLCanvas.unwrap((AWTGraphicsConfiguration)GLDrawableFactory.getFactory().chooseGraphicsConfiguration(gLCapabilities, gLCapabilitiesChooser, new AWTGraphicsDevice(graphicsDevice))));
        this.drawable = GLDrawableFactory.getFactory().getGLDrawable(this, gLCapabilities, gLCapabilitiesChooser);
        this.context = (GLContextImpl)this.drawable.createContext(gLContext);
        this.context.setSynchronized(true);
    }

    public GLContext createContext(GLContext gLContext) {
        return this.drawable.createContext(gLContext);
    }

    public void setRealized(boolean bl) {
    }

    public void display() {
        this.maybeDoSingleThreadedWorkaround(this.displayOnEventDispatchThreadAction, this.displayAction);
    }

    public void paint(Graphics graphics) {
        this.display();
    }

    public void addNotify() {
        super.addNotify();
        this.disableBackgroundErase();
        this.drawable.setRealized(true);
        if (DEBUG) {
            System.err.println("GLCanvas.addNotify()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        try {
            if (Threading.isSingleThreaded() && !Threading.isOpenGLThread()) {
                if (Threading.isAWTMode() && Thread.holdsLock(this.getTreeLock())) {
                    this.destroyAction.run();
                } else {
                    Threading.invokeOnOpenGLThread(this.destroyAction);
                }
            } else {
                this.destroyAction.run();
            }
            Object var2_1 = null;
            this.drawable.setRealized(false);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.drawable.setRealized(false);
            super.removeNotify();
            if (DEBUG) {
                System.err.println("GLCanvas.removeNotify()");
            }
            throw throwable;
        }
        super.removeNotify();
        if (DEBUG) {
            System.err.println("GLCanvas.removeNotify()");
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.sendReshape = true;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void addGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.addGLEventListener(gLEventListener);
    }

    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.removeGLEventListener(gLEventListener);
    }

    public GLContext getContext() {
        return this.context;
    }

    public GL getGL() {
        return this.getContext().getGL();
    }

    public void setGL(GL gL) {
        this.getContext().setGL(gL);
    }

    public void setAutoSwapBufferMode(boolean bl) {
        this.drawableHelper.setAutoSwapBufferMode(bl);
    }

    public boolean getAutoSwapBufferMode() {
        return this.drawableHelper.getAutoSwapBufferMode();
    }

    public void swapBuffers() {
        this.maybeDoSingleThreadedWorkaround(this.swapBuffersOnEventDispatchThreadAction, this.swapBuffersAction);
    }

    public GLCapabilities getChosenGLCapabilities() {
        if (this.drawable == null) {
            return null;
        }
        return this.drawable.getChosenGLCapabilities();
    }

    private void maybeDoSingleThreadedWorkaround(Runnable runnable, Runnable runnable2) {
        if (Threading.isSingleThreaded() && !Threading.isOpenGLThread()) {
            Threading.invokeOnOpenGLThread(runnable);
        } else {
            this.drawableHelper.invokeGL(this.drawable, this.context, runnable2, this.initAction);
        }
    }

    private void disableBackgroundErase() {
        if (!disableBackgroundEraseInitialized) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            disableBackgroundEraseMethod = GLCanvas.this.getToolkit().getClass().getDeclaredMethod("disableBackgroundErase", class$java$awt$Canvas == null ? (class$java$awt$Canvas = GLCanvas.class$("java.awt.Canvas")) : class$java$awt$Canvas);
                            disableBackgroundEraseMethod.setAccessible(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            disableBackgroundEraseInitialized = true;
        }
        if (disableBackgroundEraseMethod != null) {
            try {
                disableBackgroundEraseMethod.invoke((Object)this.getToolkit(), this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static GraphicsConfiguration unwrap(AWTGraphicsConfiguration aWTGraphicsConfiguration) {
        if (aWTGraphicsConfiguration == null) {
            return null;
        }
        return aWTGraphicsConfiguration.getGraphicsConfiguration();
    }

    class DestroyAction
    implements Runnable {
        DestroyAction() {
        }

        public void run() {
            GLContext gLContext = GLContext.getCurrent();
            if (gLContext == GLCanvas.this.context) {
                GLCanvas.this.context.release();
            }
            GLCanvas.this.context.destroy();
        }
    }

    class DisplayAction
    implements Runnable {
        DisplayAction() {
        }

        public void run() {
            if (GLCanvas.this.sendReshape) {
                int n = GLCanvas.this.getWidth();
                int n2 = GLCanvas.this.getHeight();
                GLCanvas.this.getGL().glViewport(0, 0, n, n2);
                GLCanvas.this.drawableHelper.reshape(GLCanvas.this, 0, 0, n, n2);
                GLCanvas.this.sendReshape = false;
            }
            GLCanvas.this.drawableHelper.display(GLCanvas.this);
        }
    }

    class DisplayOnEventDispatchThreadAction
    implements Runnable {
        DisplayOnEventDispatchThreadAction() {
        }

        public void run() {
            GLCanvas.this.drawableHelper.invokeGL(GLCanvas.this.drawable, GLCanvas.this.context, GLCanvas.this.displayAction, GLCanvas.this.initAction);
        }
    }

    class InitAction
    implements Runnable {
        InitAction() {
        }

        public void run() {
            GLCanvas.this.drawableHelper.init(GLCanvas.this);
        }
    }

    class SwapBuffersAction
    implements Runnable {
        SwapBuffersAction() {
        }

        public void run() {
            GLCanvas.this.drawable.swapBuffers();
        }
    }

    class SwapBuffersOnEventDispatchThreadAction
    implements Runnable {
        SwapBuffersOnEventDispatchThreadAction() {
        }

        public void run() {
            GLCanvas.this.drawableHelper.invokeGL(GLCanvas.this.drawable, GLCanvas.this.context, GLCanvas.this.swapBuffersAction, GLCanvas.this.initAction);
        }
    }
}

