/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.texture;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLU;

public class Texture {
    private int target;
    private int texID;
    private int texWidth;
    private int texHeight;
    private int imgWidth;
    private int imgHeight;
    private float aspectRatio;
    private boolean mustFlipVertically;
    private boolean usingAutoMipmapGeneration;
    private TextureCoords coords;
    private int estimatedMemorySize;
    private static final boolean DEBUG = Debug.debug("Texture");
    private static final boolean VERBOSE = Debug.verbose();
    private static final boolean disableNPOT = Debug.isPropertyDefined("jogl.texture.nonpot");
    private static final boolean disableTexRect = Debug.isPropertyDefined("jogl.texture.notexrect");

    Texture(TextureData textureData) throws GLException {
        GL gL = GLU.getCurrentGL();
        this.texID = Texture.createTextureID(gL);
        this.updateImage(textureData);
    }

    Texture(int n) throws GLException {
        GL gL = GLU.getCurrentGL();
        this.texID = Texture.createTextureID(gL);
        this.target = n;
    }

    public void enable() throws GLException {
        GLU.getCurrentGL().glEnable(this.target);
    }

    public void disable() throws GLException {
        GLU.getCurrentGL().glDisable(this.target);
    }

    public void bind() throws GLException {
        GLU.getCurrentGL().glBindTexture(this.target, this.texID);
    }

    public void dispose() throws GLException {
        GLU.getCurrentGL().glDeleteTextures(1, new int[]{this.texID}, 0);
        this.texID = 0;
    }

    public int getTarget() {
        return this.target;
    }

    public int getWidth() {
        return this.texWidth;
    }

    public int getHeight() {
        return this.texHeight;
    }

    public int getImageWidth() {
        return this.imgWidth;
    }

    public int getImageHeight() {
        return this.imgHeight;
    }

    public float getAspectRatio() {
        return this.aspectRatio;
    }

    public TextureCoords getImageTexCoords() {
        return this.coords;
    }

    public TextureCoords getSubImageTexCoords(int n, int n2, int n3, int n4) {
        if (this.target == 34037) {
            if (this.mustFlipVertically) {
                return new TextureCoords(n, this.texHeight - n2, n3, this.texHeight - n4);
            }
            return new TextureCoords(n, n2, n3, n4);
        }
        float f = (float)n / (float)this.texWidth;
        float f2 = (float)n2 / (float)this.texHeight;
        float f3 = (float)n3 / (float)this.texWidth;
        float f4 = (float)n4 / (float)this.texHeight;
        if (this.mustFlipVertically) {
            float f5 = (float)this.imgHeight / (float)this.texHeight;
            return new TextureCoords(f, f5 - f2, f3, f5 - f4);
        }
        return new TextureCoords(f, f2, f3, f4);
    }

    public void updateImage(TextureData textureData) throws GLException {
        this.updateImage(textureData, 0);
    }

    public boolean getMustFlipVertically() {
        return this.mustFlipVertically;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateImage(TextureData textureData, int n) throws GLException {
        int n2;
        Object[] objectArray;
        boolean bl;
        GL gL = GLU.getCurrentGL();
        this.imgWidth = textureData.getWidth();
        this.imgHeight = textureData.getHeight();
        this.aspectRatio = (float)this.imgWidth / (float)this.imgHeight;
        this.mustFlipVertically = textureData.getMustFlipVertically();
        int n3 = 0;
        int n4 = this.target;
        boolean bl2 = bl = gL.isExtensionAvailable("GL_VERSION_1_4") || gL.isExtensionAvailable("GL_SGIS_generate_mipmap");
        if (!(Texture.isPowerOfTwo(this.imgWidth) && Texture.isPowerOfTwo(this.imgHeight) || Texture.haveNPOT(gL))) {
            bl = false;
        }
        if (textureData.getMipmap() && !bl) {
            this.imgWidth = Texture.nextPowerOfTwo(this.imgWidth);
            this.imgHeight = Texture.nextPowerOfTwo(this.imgHeight);
            this.texWidth = this.imgWidth;
            this.texHeight = this.imgHeight;
            n3 = 3553;
        } else if (Texture.isPowerOfTwo(this.imgWidth) && Texture.isPowerOfTwo(this.imgHeight) || Texture.haveNPOT(gL)) {
            if (DEBUG) {
                if (Texture.isPowerOfTwo(this.imgWidth) && Texture.isPowerOfTwo(this.imgHeight)) {
                    System.err.println("Power-of-two texture");
                } else {
                    System.err.println("Using GL_ARB_texture_non_power_of_two");
                }
            }
            this.texWidth = this.imgWidth;
            this.texHeight = this.imgHeight;
            n3 = 3553;
        } else if (Texture.haveTexRect(gL)) {
            if (DEBUG) {
                System.err.println("Using GL_ARB_texture_rectangle");
            }
            this.texWidth = this.imgWidth;
            this.texHeight = this.imgHeight;
            n3 = 34037;
        } else {
            if (DEBUG) {
                System.err.println("Expanding texture to power-of-two dimensions");
            }
            if (textureData.getBorder() != 0) {
                throw new RuntimeException("Scaling up a non-power-of-two texture which has a border won't work");
            }
            this.texWidth = Texture.nextPowerOfTwo(this.imgWidth);
            this.texHeight = Texture.nextPowerOfTwo(this.imgHeight);
            n3 = 3553;
        }
        n4 = n3;
        this.setImageSize(this.imgWidth, this.imgHeight, n3);
        if (n != 0) {
            n3 = n;
            if (this.target == 0) {
                throw new GLException("Override of target failed; no target specified yet");
            }
            n4 = this.target;
            gL.glBindTexture(n4, this.texID);
        } else {
            gL.glBindTexture(n3, this.texID);
        }
        if (textureData.getMipmap() && !bl) {
            objectArray = new int[1];
            gL.glGetIntegerv(3317, (int[])objectArray, 0);
            gL.glPixelStorei(3317, textureData.getAlignment());
            if (textureData.isDataCompressed()) {
                throw new GLException("May not request mipmap generation for compressed textures");
            }
            try {
                GLU gLU = new GLU();
                gLU.gluBuild2DMipmaps(n3, textureData.getInternalFormat(), textureData.getWidth(), textureData.getHeight(), textureData.getPixelFormat(), textureData.getPixelType(), textureData.getBuffer());
            }
            finally {
                gL.glPixelStorei(3317, objectArray[0]);
            }
        } else {
            this.checkCompressedTextureExtensions(textureData);
            objectArray = textureData.getMipmapData();
            if (objectArray != null) {
                int n5 = this.texWidth;
                n2 = this.texHeight;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (textureData.isDataCompressed()) {
                        gL.glCompressedTexImage2D(n3, i, textureData.getInternalFormat(), n5, n2, textureData.getBorder(), objectArray[i].remaining(), (Buffer)objectArray[i]);
                    } else {
                        gL.glTexImage2D(n3, i, textureData.getInternalFormat(), n5, n2, textureData.getBorder(), textureData.getPixelFormat(), textureData.getPixelType(), null);
                        this.updateSubImageImpl(textureData, n3, i, 0, 0, 0, 0, textureData.getWidth(), textureData.getHeight());
                    }
                    n5 /= 2;
                    n2 /= 2;
                }
            } else if (textureData.isDataCompressed()) {
                gL.glCompressedTexImage2D(n3, 0, textureData.getInternalFormat(), this.texWidth, this.texHeight, textureData.getBorder(), textureData.getBuffer().capacity(), textureData.getBuffer());
            } else {
                if (textureData.getMipmap() && bl) {
                    gL.glTexParameteri(n4, 33169, 1);
                    this.usingAutoMipmapGeneration = true;
                }
                gL.glTexImage2D(n3, 0, textureData.getInternalFormat(), this.texWidth, this.texHeight, textureData.getBorder(), textureData.getPixelFormat(), textureData.getPixelType(), null);
                this.updateSubImageImpl(textureData, n3, 0, 0, 0, 0, 0, textureData.getWidth(), textureData.getHeight());
            }
        }
        int n6 = textureData.getMipmap() ? 9987 : 9729;
        int n7 = 9729;
        int n8 = n2 = gL.isExtensionAvailable("GL_VERSION_1_2") ? 33071 : 10496;
        if (n3 != 34037) {
            gL.glTexParameteri(n4, 10241, n6);
            gL.glTexParameteri(n4, 10240, n7);
            gL.glTexParameteri(n4, 10242, n2);
            gL.glTexParameteri(n4, 10243, n2);
            if (this.target == 34067) {
                gL.glTexParameteri(n4, 32882, n2);
            }
        }
        if (this.target == 0 || this.target == 3553 || this.target == 34037) {
            this.target = n3;
        }
        this.estimatedMemorySize = textureData.getEstimatedMemorySize();
    }

    public void updateSubImage(TextureData textureData, int n, int n2, int n3) throws GLException {
        if (this.usingAutoMipmapGeneration && n != 0) {
            return;
        }
        this.bind();
        this.updateSubImageImpl(textureData, this.target, n, n2, n3, 0, 0, textureData.getWidth(), textureData.getHeight());
    }

    public void updateSubImage(TextureData textureData, int n, int n2, int n3, int n4, int n5, int n6, int n7) throws GLException {
        if (textureData.isDataCompressed()) {
            throw new GLException("updateSubImage specifying a sub-rectangle is not supported for compressed TextureData");
        }
        if (this.usingAutoMipmapGeneration && n != 0) {
            return;
        }
        this.bind();
        this.updateSubImageImpl(textureData, this.target, n, n2, n3, n4, n5, n6, n7);
    }

    public void setTexParameterf(int n, float f) {
        this.bind();
        GL gL = GLU.getCurrentGL();
        gL.glTexParameterf(this.target, n, f);
    }

    public void setTexParameterfv(int n, FloatBuffer floatBuffer) {
        this.bind();
        GL gL = GLU.getCurrentGL();
        gL.glTexParameterfv(this.target, n, floatBuffer);
    }

    public void setTexParameterfv(int n, float[] fArray, int n2) {
        this.bind();
        GL gL = GLU.getCurrentGL();
        gL.glTexParameterfv(this.target, n, fArray, n2);
    }

    public void setTexParameteri(int n, int n2) {
        this.bind();
        GL gL = GLU.getCurrentGL();
        gL.glTexParameteri(this.target, n, n2);
    }

    public void setTexParameteriv(int n, IntBuffer intBuffer) {
        this.bind();
        GL gL = GLU.getCurrentGL();
        gL.glTexParameteriv(this.target, n, intBuffer);
    }

    public void setTexParameteriv(int n, int[] nArray, int n2) {
        this.bind();
        GL gL = GLU.getCurrentGL();
        gL.glTexParameteriv(this.target, n, nArray, n2);
    }

    public int getTextureObject() {
        return this.texID;
    }

    public int getEstimatedMemorySize() {
        return this.estimatedMemorySize;
    }

    public boolean isUsingAutoMipmapGeneration() {
        return this.usingAutoMipmapGeneration;
    }

    private static boolean isPowerOfTwo(int n) {
        return (n & n - 1) == 0;
    }

    private static int nextPowerOfTwo(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    private void setImageSize(int n, int n2, int n3) {
        this.imgWidth = n;
        this.imgHeight = n2;
        this.coords = n3 == 34037 ? (this.mustFlipVertically ? new TextureCoords(0.0f, this.imgHeight, this.imgWidth, 0.0f) : new TextureCoords(0.0f, 0.0f, this.imgWidth, this.imgHeight)) : (this.mustFlipVertically ? new TextureCoords(0.0f, (float)this.imgHeight / (float)this.texHeight, (float)this.imgWidth / (float)this.texWidth, 0.0f) : new TextureCoords(0.0f, 0.0f, (float)this.imgWidth / (float)this.texWidth, (float)this.imgHeight / (float)this.texHeight));
    }

    private void updateSubImageImpl(TextureData textureData, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws GLException {
        Buffer buffer;
        GL gL = GLU.getCurrentGL();
        if (gL.isExtensionAvailable("GL_EXT_abgr")) {
            textureData.setHaveEXTABGR(true);
        }
        if ((buffer = textureData.getBuffer()) == null && textureData.getMipmapData() == null) {
            return;
        }
        int n9 = textureData.getRowLength();
        int n10 = textureData.getWidth();
        int n11 = textureData.getHeight();
        if (textureData.getMipmapData() != null) {
            for (int i = 0; i < n2; ++i) {
                n7 /= 2;
                n8 /= 2;
                n10 /= 2;
                n11 /= 2;
            }
            n9 = 0;
            buffer = textureData.getMipmapData()[n2];
        }
        if (n5 < 0) {
            n7 += n5;
            n5 = 0;
        }
        if (n6 < 0) {
            n8 += n6;
            n6 = 0;
        }
        if (n3 < 0) {
            n7 += n3;
            n3 = 0;
        }
        if (n4 < 0) {
            n8 += n4;
            n4 = 0;
        }
        if (n5 + n7 > n10) {
            n7 = n10 - n5;
        }
        if (n6 + n8 > n11) {
            n8 = n11 - n6;
        }
        if (n3 + n7 > this.texWidth) {
            n7 = this.texWidth - n3;
        }
        if (n4 + n8 > this.texHeight) {
            n8 = this.texHeight - n4;
        }
        this.checkCompressedTextureExtensions(textureData);
        if (textureData.isDataCompressed()) {
            gL.glCompressedTexSubImage2D(n, n2, n3, n4, n7, n8, textureData.getInternalFormat(), buffer.remaining(), buffer);
        } else {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[1];
            gL.glGetIntegerv(3317, nArray, 0);
            gL.glGetIntegerv(3314, nArray2, 0);
            gL.glGetIntegerv(3315, nArray3, 0);
            gL.glGetIntegerv(3316, nArray4, 0);
            gL.glPixelStorei(3317, textureData.getAlignment());
            if (DEBUG && VERBOSE) {
                System.out.println("Row length  = " + n9);
                System.out.println("skip pixels = " + n5);
                System.out.println("skip rows   = " + n6);
                System.out.println("dstx        = " + n3);
                System.out.println("dsty        = " + n4);
                System.out.println("width       = " + n7);
                System.out.println("height      = " + n8);
            }
            gL.glPixelStorei(3314, n9);
            gL.glPixelStorei(3315, n6);
            gL.glPixelStorei(3316, n5);
            gL.glTexSubImage2D(n, n2, n3, n4, n7, n8, textureData.getPixelFormat(), textureData.getPixelType(), buffer);
            gL.glPixelStorei(3317, nArray[0]);
            gL.glPixelStorei(3314, nArray2[0]);
            gL.glPixelStorei(3315, nArray3[0]);
            gL.glPixelStorei(3316, nArray4[0]);
        }
    }

    private void checkCompressedTextureExtensions(TextureData textureData) {
        GL gL = GLU.getCurrentGL();
        if (textureData.isDataCompressed()) {
            switch (textureData.getInternalFormat()) {
                case 33776: 
                case 33777: 
                case 33778: 
                case 33779: {
                    if (gL.isExtensionAvailable("GL_EXT_texture_compression_s3tc") || gL.isExtensionAvailable("GL_NV_texture_compression_vtc")) break;
                    throw new GLException("DXTn compressed textures not supported by this graphics card");
                }
            }
        }
    }

    private static int createTextureID(GL gL) {
        int[] nArray = new int[1];
        gL.glGenTextures(1, nArray, 0);
        return nArray[0];
    }

    private static boolean haveNPOT(GL gL) {
        return !disableNPOT && gL.isExtensionAvailable("GL_ARB_texture_non_power_of_two");
    }

    private static boolean haveTexRect(GL gL) {
        return !disableTexRect && TextureIO.isTexRectEnabled() && gL.isExtensionAvailable("GL_ARB_texture_rectangle");
    }
}

