#include "glm.h"
GLMmodel *model1,*model2,*model3;

#include "glut.h"
//#include <GL/glu.h>
//#include <GL/gl.h>
#include <stdlib.h>
#include <stdarg.h>

#include <iostream>
#include <memory.h>
#include <time.h>
#include <fstream>
using namespace std;

// Default Image dimensions
int imageWidth = 640;
int imageHeight = 480;

// the circle object, initialized in setupGL()
GLUquadricObj* circle = NULL;  

//OpenGL Calls
void setupGL();
void CheckGLError();

//Callbacks
void Display();
void Idle();
void Reshape(int w, int h);
void Keyboard (unsigned char key, int , int );
void MouseButton(int button, int state, int x, int y);
void MouseMotion(int x, int y);

//font
GLvoid *font_style = GLUT_BITMAP_HELVETICA_12;

// a cleanup function
void quit(int i = 0);

void main(int argc, char **argv)
{
	// INITIALIZE THE GLUT WINDOW
	glutInit(&argc, argv);  
	glutInitWindowSize(imageWidth, imageHeight);
	glutInitDisplayString("rgb double");
	glutInitWindowPosition(0, 0);
	glutCreateWindow("Project #1");

	//SETUP GLUT CALLBACKS
	cout << "Setting up callbacks... ";
	glutDisplayFunc(Display);
	glutKeyboardFunc(Keyboard);
	glutMouseFunc(MouseButton);
	glutMotionFunc(MouseMotion);
	glutReshapeFunc(Reshape);
	glutIdleFunc(Idle);
	cout << "[completed]\n";
	glEnable(GL_DEPTH_TEST);

	//SETUP MISC GL
	setupGL();

	CheckGLError();
	model1= glmReadOBJ("data/cube.obj");
	model2= glmReadOBJ("data/sphere.obj");
	model3= glmReadOBJ("data/torus.obj");
	glutMainLoop();
}



// This function checks the state of openGL and prints 
// an error if an error has occurred
void CheckGLError()
{
  	GLenum error;
  	error = glGetError();
  	if (error!=GL_NO_ERROR)
  	{
		cout << "OpenGL reports an error: "<< gluErrorString(error) << endl;
		quit(1);
  	}
}

//drawstr method from Nate Robbins tutorials, 1997
void 
drawstr(GLuint x, GLuint y, char* format, ...)
{
	
    va_list args;
    char buffer[255], *s;
    
    va_start(args, format);
    vsprintf(buffer, format, args);
    va_end(args);
    
    glRasterPos2i(x, y);
    for (s = buffer; *s; s++)
        glutBitmapCharacter(font_style, *s);
}


// This function draws the scene
int angle=0;
void Display()
{
	if (!circle) { 
		cout << "The circle object is not defined!  Quitting..." << endl;
		quit(1);
	}
	angle++;
	if(angle>3600)
		angle=0;

	// clear the screen
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glPushMatrix();
	// set the color to white
		glScalef(10,10,0.01);
		glTranslatef(0,-5,0);
		glRotatef(angle/10.0,0,0,1);
		glmDraw(model1,GLM_TEXTURE);
	glPopMatrix();
	glPushMatrix();
		glScalef(1,1,0.01);
		glTranslatef(15,15,0);
		glRotatef(angle/10.0,0,0,1);
		glmDraw(model2,GLM_TEXTURE);
	glPopMatrix();
	glPushMatrix();
		glScalef(1,1,0.01);
		glTranslatef(-35,15,0);
		glRotatef(angle/10.0,0,0,1);
		glmDraw(model3,GLM_TEXTURE);
	glPopMatrix();

	//draw text
	drawstr(30.0, 460, "x = ");
	drawstr(50.0, 460, "%.1f", 3.0);
	// swap the buffers
	glutSwapBuffers();
}




// set up GL stuff
void setupGL() {

	// set the clear color
	glClearColor(0.0, 0.0, 0.0, 1.0);  // background color

	// initialize the circle object
	circle = gluNewQuadric();
	if (!circle) { 
		cout << "The circle object could not be created!  Quitting..." << endl;
		quit(1);
	}
}


// This function is continuously called when events are not being received
// by the window.  This is a good place to update the state of your objects 
// after every frame.
void Idle() {
	glutPostRedisplay();

}

// keyboard handler
void Keyboard (unsigned char key, int , int )
{
	switch(key)
    {
		// if esc or q, exit
		case 27:
        case 'q':
			quit(1);
			break;
	}
}

void MouseButton(int button, int state, int x, int y)
{
	switch (button) 
	{
		case GLUT_LEFT_BUTTON:
		    break;
		case GLUT_MIDDLE_BUTTON:
		    break;
		case GLUT_RIGHT_BUTTON:
		    break;
	}
}

void MouseMotion(int x, int y)
{
}

// This functions handles what happens when the window is reshaped
void Reshape(int w, int h) 
{
	imageWidth = w;
	imageHeight = h;

   	glViewport(0,0,w,h);

	glMatrixMode(GL_PROJECTION);
   	glLoadIdentity();
	gluOrtho2D(-100,100,-100,100);

    glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
}

// a cleanup function.  call this when you want to exit.
void quit(int i) 
{
	// cleanup the circle object
	if (circle)
		gluDeleteQuadric(circle);

	exit(i);
}