/* Rotating cube demo with trackball*/
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "glut.h"

#define bool int
#define false 0
#define true 1

void draw();
int 	winWidth=500, winHeight=500;
GLfloat angle = 0.0, axis[3];

bool 	trackingMouse = false;
bool 	redrawContinue = false;
bool    trackballMove = false;


/*----------------------------------------------------------------------*/
/* 
** These functions implement a simple trackball-like motion control.
*/

GLfloat lastPos[3] = {0.0, 0.0, 0.0};
int curx, cury;
int startX, startY;

void trackball_ptov(int x, int y, int width, int height, float v[3])
{
    float d, a;

   /* --- project x,y onto a hemi-sphere centered within width, height */
    v[0] = (2.0*x - width) / width;
    v[1] = -(2.0*y - height) / height; 
	d = v[0]*v[0] + v[1]*v[1];
	d = (d < 1.0) ? d : 1.0; /* keep below or equal to 1 */
    v[2] = sqrt(1-d);
	a = sqrt(d + v[2]*v[2]);
    v[0] /= a;
    v[1] /= a;
    v[2] /= a;
}



void mouseMotion(int x, int y)
{
    float curPos[3], dx, dy, dz;

    trackball_ptov(x, y, winWidth, winHeight, curPos);
    if(trackingMouse)
    {
	dx = curPos[0] - lastPos[0];
	dy = curPos[1] - lastPos[1];
	dz = curPos[2] - lastPos[2];

	if (dx || dy || dz) {
	    angle = 90.0 * sqrt(dx*dx + dy*dy + dz*dz);

	    /* axis = Pold x P */
	    axis[0] = lastPos[1]*curPos[2] - lastPos[2]*curPos[1];
	    axis[1] = lastPos[2]*curPos[0] - lastPos[0]*curPos[2];
	    axis[2] = lastPos[0]*curPos[1] - lastPos[1]*curPos[0];

	    lastPos[0] = curPos[0];
	    lastPos[1] = curPos[1];
	    lastPos[2] = curPos[2];
	}
    }
    
    glutPostRedisplay();
}

void startMotion(int x, int y)
{
    trackingMouse = true;
    redrawContinue = false;
    startX = x; startY = y;
    curx = x; cury = y;
    trackball_ptov(x, y, winWidth, winHeight, lastPos);
    trackballMove=true;
}

void stopMotion(int x, int y)
{

    trackingMouse = false;

    if (startX != x || startY != y) {
	redrawContinue = true;
    } else {
	angle = 0.0;
	redrawContinue = false;
	trackballMove = false;
    }
}

/*----------------------------------------------------------------------*/

void display(void)
{
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);

    /* modelview transform */
    if (trackballMove) 
        glRotatef(angle, axis[0], axis[1], axis[2]);
    draw();
    glutSwapBuffers();
}

/*----------------------------------------------------------------------*/

void mouseButton(int button, int state, int x, int y)
{
   if(button==GLUT_RIGHT_BUTTON) exit(0);

    if(button==GLUT_LEFT_BUTTON) switch(state) 
    {
    case GLUT_DOWN:
	startMotion( x,y);
	break;
    case GLUT_UP:
	stopMotion( x,y);
	break;
    } 
}

void myReshape(int w, int h)
{
//    glViewport(0, 0, w, h);
    winWidth = w;
    winHeight = h;
}

void spin()
{
    if (redrawContinue) glutPostRedisplay();
}

