// input : as for Pcp2Nurb 
// output: coefficients of four cubic patches 
//            10     
//           8  9    
//         5  6  7   
//        1  2  3  4 
//
// generated by jorg@cise.ufl.edu 1999, 
// free to academia, all commercial rights reserved

#include <math.h>
#define DIM 3
void Pcp2Bezier(float Ci[][DIM], int valence[],
    float ctl_pt[][DIM]) 
{
    int m;
    double     c[4],mypi = 4*atan(1.0);
    c[1] = c[3] =0;
    c[0] = cos(2*mypi/valence[0]);
    c[2] = cos(2*mypi/valence[1]);
    for (m=0; m<DIM; m++) {
      ctl_pt[0][m] = Ci[0][m]/4.0+Ci[1][m]/4.0+Ci[2][m]/4.0+Ci[3][m]/4.0;
      ctl_pt[1][m] = 5.0/12.0*Ci[0][m]+Ci[1][m]/12.0+Ci[2][m]/12.0+5.0/12.0*Ci[3][m];
      ctl_pt[2][m] = Ci[4][m]/3.0+Ci[0][m]/3.0+Ci[3][m]/3.0;
      ctl_pt[3][m] = Ci[4][m];
      ctl_pt[4][m] = 5.0/12.0*Ci[0][m]+Ci[1][m]/4.0+Ci[2][m]/12.0+Ci[3][m]/4.0;
      ctl_pt[5][m] = (2.0-c[0])*(Ci[0][m]/2.0+Ci[3][m]/2.0)/6.0+(1.0+c[0])*(Ci[0][m]/
4.0+Ci[1][m]/4.0+Ci[2][m]/4.0+Ci[3][m]/4.0)/6.0+Ci[0][m]/3.0+Ci[4][m]/6.0;
      ctl_pt[6][m] = Ci[4][m]/3.0+Ci[0][m]/3.0+Ci[3][m]/6.0+Ci[5][m]/6.0;
      ctl_pt[7][m] = (2.0-c[2])*(Ci[0][m]/2.0+Ci[1][m]/2.0)/12.0+(1.0+c[2])*(Ci[0][m]
/4.0+Ci[1][m]/4.0+Ci[2][m]/4.0+Ci[3][m]/4.0)/12.0+Ci[0][m]/3.0+Ci[8][m]/12.0+(
2.0-c[0])*(Ci[0][m]/2.0+Ci[3][m]/2.0)/12.0+(1.0+c[0])*(Ci[0][m]/4.0+Ci[1][m]/
4.0+Ci[2][m]/4.0+Ci[3][m]/4.0)/12.0+Ci[4][m]/12.0;
      ctl_pt[8][m] = (2.0-c[0])*(Ci[0][m]/2.0+Ci[3][m]/2.0)/12.0+(1.0+c[0])*(Ci[0][m]
/4.0+Ci[1][m]/4.0+Ci[2][m]/4.0+Ci[3][m]/4.0)/12.0+Ci[0][m]/3.0+Ci[4][m]/6.0+(
2.0-c[0])*(Ci[0][m]/2.0+Ci[5][m]/2.0)/12.0+(1.0+c[0])*(Ci[0][m]/4.0+Ci[5][m]/
4.0+Ci[6][m]/4.0+Ci[7][m]/4.0)/12.0;
      ctl_pt[9][m] = (2.0-c[2])*(Ci[0][m]/2.0+Ci[1][m]/2.0)/24.0+(1.0+c[2])*(Ci[0][m]
/4.0+Ci[1][m]/4.0+Ci[2][m]/4.0+Ci[3][m]/4.0)/24.0+Ci[0][m]/3.0+Ci[8][m]/12.0+(
2.0-c[0])*(Ci[0][m]/2.0+Ci[3][m]/2.0)/24.0+(1.0+c[0])*(Ci[0][m]/4.0+Ci[1][m]/
4.0+Ci[2][m]/4.0+Ci[3][m]/4.0)/24.0+Ci[4][m]/12.0+(2.0-c[0])*(Ci[0][m]/2.0+Ci
[5][m]/2.0)/24.0+(1.0+c[0])*(Ci[0][m]/4.0+Ci[5][m]/4.0+Ci[6][m]/4.0+Ci[7][m]/
4.0)/24.0+(2.0-c[2])*(Ci[0][m]/2.0+Ci[7][m]/2.0)/24.0+(1.0+c[2])*(Ci[0][m]/4.0+
Ci[5][m]/4.0+Ci[6][m]/4.0+Ci[7][m]/4.0)/24.0;
      ctl_pt[10][m] = Ci[4][m];
      ctl_pt[11][m] = Ci[4][m]/3.0+Ci[0][m]/3.0+Ci[5][m]/3.0;
      ctl_pt[12][m] = 5.0/12.0*Ci[0][m]+5.0/12.0*Ci[5][m]+Ci[6][m]/12.0+Ci[7][m]/12.0
;
      ctl_pt[13][m] = Ci[0][m]/4.0+Ci[5][m]/4.0+Ci[6][m]/4.0+Ci[7][m]/4.0;
      ctl_pt[14][m] = Ci[4][m]/3.0+Ci[0][m]/3.0+Ci[3][m]/6.0+Ci[5][m]/6.0;
      ctl_pt[15][m] = (2.0-c[0])*(Ci[0][m]/2.0+Ci[5][m]/2.0)/6.0+(1.0+c[0])*(Ci[0][m]
/4.0+Ci[5][m]/4.0+Ci[6][m]/4.0+Ci[7][m]/4.0)/6.0+Ci[0][m]/3.0+Ci[4][m]/6.0;
      ctl_pt[16][m] = 5.0/12.0*Ci[0][m]+Ci[5][m]/4.0+Ci[6][m]/12.0+Ci[7][m]/4.0;
      ctl_pt[17][m] = (2.0-c[0])*(Ci[0][m]/2.0+Ci[3][m]/2.0)/12.0+(1.0+c[0])*(Ci[0]
[m]/4.0+Ci[1][m]/4.0+Ci[2][m]/4.0+Ci[3][m]/4.0)/12.0+Ci[0][m]/3.0+Ci[4][m]/6.0+
(2.0-c[0])*(Ci[0][m]/2.0+Ci[5][m]/2.0)/12.0+(1.0+c[0])*(Ci[0][m]/4.0+Ci[5][m]/
4.0+Ci[6][m]/4.0+Ci[7][m]/4.0)/12.0;
      ctl_pt[18][m] = (2.0-c[0])*(Ci[0][m]/2.0+Ci[5][m]/2.0)/12.0+(1.0+c[0])*(Ci[0]
[m]/4.0+Ci[5][m]/4.0+Ci[6][m]/4.0+Ci[7][m]/4.0)/12.0+Ci[0][m]/3.0+Ci[4][m]/12.0
+(2.0-c[2])*(Ci[0][m]/2.0+Ci[7][m]/2.0)/12.0+(1.0+c[2])*(Ci[0][m]/4.0+Ci[5][m]/
4.0+Ci[6][m]/4.0+Ci[7][m]/4.0)/12.0+Ci[8][m]/12.0;
      ctl_pt[19][m] = (2.0-c[2])*(Ci[0][m]/2.0+Ci[1][m]/2.0)/24.0+(1.0+c[2])*(Ci[0]
[m]/4.0+Ci[1][m]/4.0+Ci[2][m]/4.0+Ci[3][m]/4.0)/24.0+Ci[0][m]/3.0+Ci[8][m]/12.0
+(2.0-c[0])*(Ci[0][m]/2.0+Ci[3][m]/2.0)/24.0+(1.0+c[0])*(Ci[0][m]/4.0+Ci[1][m]/
4.0+Ci[2][m]/4.0+Ci[3][m]/4.0)/24.0+Ci[4][m]/12.0+(2.0-c[0])*(Ci[0][m]/2.0+Ci
[5][m]/2.0)/24.0+(1.0+c[0])*(Ci[0][m]/4.0+Ci[5][m]/4.0+Ci[6][m]/4.0+Ci[7][m]/
4.0)/24.0+(2.0-c[2])*(Ci[0][m]/2.0+Ci[7][m]/2.0)/24.0+(1.0+c[2])*(Ci[0][m]/4.0+
Ci[5][m]/4.0+Ci[6][m]/4.0+Ci[7][m]/4.0)/24.0;
      ctl_pt[20][m] = Ci[0][m]/4.0+Ci[5][m]/4.0+Ci[6][m]/4.0+Ci[7][m]/4.0;
      ctl_pt[21][m] = 5.0/12.0*Ci[0][m]+Ci[5][m]/12.0+Ci[6][m]/12.0+5.0/12.0*Ci[7][m]
;
      ctl_pt[22][m] = Ci[8][m]/3.0+Ci[0][m]/3.0+Ci[7][m]/3.0;
      ctl_pt[23][m] = Ci[8][m];
      ctl_pt[24][m] = 5.0/12.0*Ci[0][m]+Ci[5][m]/4.0+Ci[6][m]/12.0+Ci[7][m]/4.0;
      ctl_pt[25][m] = (2.0-c[2])*(Ci[0][m]/2.0+Ci[7][m]/2.0)/6.0+(1.0+c[2])*(Ci[0][m]
/4.0+Ci[5][m]/4.0+Ci[6][m]/4.0+Ci[7][m]/4.0)/6.0+Ci[0][m]/3.0+Ci[8][m]/6.0;
      ctl_pt[26][m] = Ci[8][m]/3.0+Ci[0][m]/3.0+Ci[7][m]/6.0+Ci[1][m]/6.0;
      ctl_pt[27][m] = (2.0-c[0])*(Ci[0][m]/2.0+Ci[5][m]/2.0)/12.0+(1.0+c[0])*(Ci[0]
[m]/4.0+Ci[5][m]/4.0+Ci[6][m]/4.0+Ci[7][m]/4.0)/12.0+Ci[0][m]/3.0+Ci[4][m]/12.0
+(2.0-c[2])*(Ci[0][m]/2.0+Ci[7][m]/2.0)/12.0+(1.0+c[2])*(Ci[0][m]/4.0+Ci[5][m]/
4.0+Ci[6][m]/4.0+Ci[7][m]/4.0)/12.0+Ci[8][m]/12.0;
      ctl_pt[28][m] = (2.0-c[2])*(Ci[0][m]/2.0+Ci[7][m]/2.0)/12.0+(1.0+c[2])*(Ci[0]
[m]/4.0+Ci[5][m]/4.0+Ci[6][m]/4.0+Ci[7][m]/4.0)/12.0+Ci[0][m]/3.0+Ci[8][m]/6.0+
(2.0-c[2])*(Ci[0][m]/2.0+Ci[1][m]/2.0)/12.0+(1.0+c[2])*(Ci[0][m]/4.0+Ci[1][m]/
4.0+Ci[2][m]/4.0+Ci[3][m]/4.0)/12.0;
      ctl_pt[29][m] = (2.0-c[2])*(Ci[0][m]/2.0+Ci[1][m]/2.0)/24.0+(1.0+c[2])*(Ci[0]
[m]/4.0+Ci[1][m]/4.0+Ci[2][m]/4.0+Ci[3][m]/4.0)/24.0+Ci[0][m]/3.0+Ci[8][m]/12.0
+(2.0-c[0])*(Ci[0][m]/2.0+Ci[3][m]/2.0)/24.0+(1.0+c[0])*(Ci[0][m]/4.0+Ci[1][m]/
4.0+Ci[2][m]/4.0+Ci[3][m]/4.0)/24.0+Ci[4][m]/12.0+(2.0-c[0])*(Ci[0][m]/2.0+Ci
[5][m]/2.0)/24.0+(1.0+c[0])*(Ci[0][m]/4.0+Ci[5][m]/4.0+Ci[6][m]/4.0+Ci[7][m]/
4.0)/24.0+(2.0-c[2])*(Ci[0][m]/2.0+Ci[7][m]/2.0)/24.0+(1.0+c[2])*(Ci[0][m]/4.0+
Ci[5][m]/4.0+Ci[6][m]/4.0+Ci[7][m]/4.0)/24.0;
      ctl_pt[30][m] = Ci[8][m];
      ctl_pt[31][m] = Ci[8][m]/3.0+Ci[0][m]/3.0+Ci[1][m]/3.0;
      ctl_pt[32][m] = 5.0/12.0*Ci[0][m]+5.0/12.0*Ci[1][m]+Ci[2][m]/12.0+Ci[3][m]/12.0
;
      ctl_pt[33][m] = Ci[0][m]/4.0+Ci[1][m]/4.0+Ci[2][m]/4.0+Ci[3][m]/4.0;
      ctl_pt[34][m] = Ci[8][m]/3.0+Ci[0][m]/3.0+Ci[7][m]/6.0+Ci[1][m]/6.0;
      ctl_pt[35][m] = (2.0-c[2])*(Ci[0][m]/2.0+Ci[1][m]/2.0)/6.0+(1.0+c[2])*(Ci[0][m]
/4.0+Ci[1][m]/4.0+Ci[2][m]/4.0+Ci[3][m]/4.0)/6.0+Ci[0][m]/3.0+Ci[8][m]/6.0;
      ctl_pt[36][m] = 5.0/12.0*Ci[0][m]+Ci[1][m]/4.0+Ci[2][m]/12.0+Ci[3][m]/4.0;
      ctl_pt[37][m] = (2.0-c[2])*(Ci[0][m]/2.0+Ci[7][m]/2.0)/12.0+(1.0+c[2])*(Ci[0]
[m]/4.0+Ci[5][m]/4.0+Ci[6][m]/4.0+Ci[7][m]/4.0)/12.0+Ci[0][m]/3.0+Ci[8][m]/6.0+
(2.0-c[2])*(Ci[0][m]/2.0+Ci[1][m]/2.0)/12.0+(1.0+c[2])*(Ci[0][m]/4.0+Ci[1][m]/
4.0+Ci[2][m]/4.0+Ci[3][m]/4.0)/12.0;
      ctl_pt[38][m] = (2.0-c[2])*(Ci[0][m]/2.0+Ci[1][m]/2.0)/12.0+(1.0+c[2])*(Ci[0]
[m]/4.0+Ci[1][m]/4.0+Ci[2][m]/4.0+Ci[3][m]/4.0)/12.0+Ci[0][m]/3.0+Ci[8][m]/12.0
+(2.0-c[0])*(Ci[0][m]/2.0+Ci[3][m]/2.0)/12.0+(1.0+c[0])*(Ci[0][m]/4.0+Ci[1][m]/
4.0+Ci[2][m]/4.0+Ci[3][m]/4.0)/12.0+Ci[4][m]/12.0;
      ctl_pt[39][m] = (2.0-c[2])*(Ci[0][m]/2.0+Ci[1][m]/2.0)/24.0+(1.0+c[2])*(Ci[0]
[m]/4.0+Ci[1][m]/4.0+Ci[2][m]/4.0+Ci[3][m]/4.0)/24.0+Ci[0][m]/3.0+Ci[8][m]/12.0
+(2.0-c[0])*(Ci[0][m]/2.0+Ci[3][m]/2.0)/24.0+(1.0+c[0])*(Ci[0][m]/4.0+Ci[1][m]/
4.0+Ci[2][m]/4.0+Ci[3][m]/4.0)/24.0+Ci[4][m]/12.0+(2.0-c[0])*(Ci[0][m]/2.0+Ci
[5][m]/2.0)/24.0+(1.0+c[0])*(Ci[0][m]/4.0+Ci[5][m]/4.0+Ci[6][m]/4.0+Ci[7][m]/
4.0)/24.0+(2.0-c[2])*(Ci[0][m]/2.0+Ci[7][m]/2.0)/24.0+(1.0+c[2])*(Ci[0][m]/4.0+
Ci[5][m]/4.0+Ci[6][m]/4.0+Ci[7][m]/4.0)/24.0;
    }
}



