% TST_SUPPORT -- Test driver for support

% Created by lutter on Mon Oct 25 15:14:42 1999
%
%

global cred cblack cblue

maxc = 0;
below = 0;
knots = -3:6;
bd = bdubeta(knots, 3);
a = spmak([0 0:3 3], [0 1 1 0]);

clf;
set(gca, 'XLim', [-1 4]);
set(gca, 'YLim', [-1/2 3/2]);
q = fnplt(a, xint);
line(q(1,:), q(2,:), 'Color', cred);
legend('Input polygon');


disp('Press <RETURN> to continue');
pause;

p = support(bd, a, below, maxc);
xint = a.knots([1 end]);
q = fnplt(p, xint);
line(q(1,:), q(2,:), 'Color', cblack);
line(bd.grev, p.coefs, 'Color', cblack, 'MarkerFaceColor', cblack, ...
     'Marker', 's');
legend('Input polygon', 'Solution');

disp('Press <RETURN> to continue');
pause;

%%
%% Andrew: you can ignore the rest of this file
%%
return


for ref=1:3
  fprintf('\n%d times refined\n', ref);
  [S, rknots] = ucubrfn(knots, ref);
  bdr = bdubeta(rknots, 3);
  pr = support(bdr, a, below, maxc, S, bd.knots);
  q = fnplt(pr, xint);
  line(q(1,:), q(2,:), 'Color', cblue);
  %line(aveknt(pr.knots, 4), pr.coefs, 'Color', cblue, ...
  %     'Marker', 's', 'MarkerFaceColor', cblue);
  if ref<3
    disp('Press <RETURN> to continue');
    pause;
  end
end
