function plotenv(bd, ctrl, varargin)
% plotenv(bound, ctrl, [draw_cpoly=1])
% PLOTENV -- Plot the spline with knots BD.KNOTS and ctrl points CTRL and its
%            envelope given BD

% Created by lutter on Thu Oct 22 17:30:17 1998
%
%

global cblack corange

if nargin < 3 draw_cpoly=1; end 

[lower, upper] = bdspan(bd, ctrl);

draw_cpoly = 1;
envColor = corange;
splineColor = cblack;
barColor = 'none';
connectColor = 'none';
for i=1:2:length(varargin)
  if strcmpi('DrawCPoly', varargin{i})
    draw_cpoly = varargin{i+1};
  elseif strcmpi('EnvColor', varargin{i})
    envColor = varargin{i+1};
  elseif strcmpi('SplineColor', varargin{i})
    splineColor = varargin{i+1};
  elseif strcmpi('BarColor', varargin{i})
    barColor = varargin{i+1};
  elseif strcmpi('ConnectColor', varargin{i})
    connectColor = varargin{i+1};
  else
    error('Unknown optional argument');
  end
end

lower = ctrl + lower;
upper = ctrl + upper;

k = length(bd.knots);
m = length(ctrl);
d = bd.deg;

grev = bd.grev;
sp = spmak(bd.knots, ctrl);

%% Plot the B--Spline + ctrl poly
x = linspace(max(bd.grev(1), bd.knots(d+1)), ...
	     min(bd.grev(m), bd.knots(k-d)), ...
	     40*m);
p = fnval(sp, x);
line(x, p, 'Color', splineColor);
if draw_cpoly==1
  line(grev, ctrl, 'Color', splineColor, ...
       'Marker', 's', 'MarkerFaceColor', splineColor);
end
%% Plot the lower and upper bounds
if ~ strcmpi(envColor, 'none')
  plot_poly(bd, lower, envColor);
  plot_poly(bd, upper, envColor);
end
if ~ strcmpi(connectColor, 'none')
  plot_poly(bd, (upper+lower)/2, connectColor);
end
if ~ strcmpi(barColor, 'none')
  for i=1:m
    line(bd.grev([i i]), [lower(i) upper(i)], 'Color', barColor);
  end
end
if draw_cpoly==-1
  line(grev, ctrl, 'Color', splineColor, ...
       'Marker', 's', 'MarkerFaceColor', splineColor);
end

%% Verify that lower <= sp <= upper
pl = linval(grev, lower, x);
pu = linval(grev, upper, x);
warn_viol('Lower', find(p-pl < -1e-8), x, p, pl);
warn_viol('Upper', find(pu-p < -1e-8), x, p, pu);

function plot_poly(bd, ctrl, ccolor)
  x = bd.grev;
  m = length(x);
  x(1) = max(x(1), bd.knots(bd.deg+1));
  x(m) = min(x(m), bd.knots(m+1));
  ind = find(x(1) <= x & x<= x(m));
  y = linval(bd.grev, ctrl, x(ind));
  line(x(ind), y, 'Color', ccolor, 'Marker', 's', ...
     'MarkerFaceColor', ccolor);
  
function y = linval(t, ctrl, x)
  m = length(ctrl);
  y = fnval(spmak(t([1 1:m m]), ctrl), x);
  
function warn_viol(str, viol, x, p, env)
  if ~ isempty(viol)
    fprintf('%s envelope violated:\n', str);
    % fprintf('  x   ___   p   ___   env\n');
    % viol = [ x(viol)' p(viol)' env(viol)' ]
  end