function bound = bdinit(t, d)
% bound = bdinit(t, d)
% bound = bdinit(sp)
% BDINIT -- Return a structure filled with the fields used frequently by
%           the bound routines. 
%           Input can either be a knot sequence T and a degree D or
%           a structure SP as returned by SPMAK in the splines toolbox.
%           Only the knots and the order from SP will be used.
%
%           Both forms return a structure with the following fields:
%              type       : 'init'
%              deg        : the degree D
%              knots      : the original knot sequence T
%              grev       : the Greville abscissae
%              lind, rind : For each Greville abscissa, the index of the
%                           first and last non-zero basis function there
%
%           This is only an auxiliary routine for BDEXP and BDCHEAP.

% Created by lutter on Fri Jan 22 17:01:09 1999
%
%

if isa(t, 'struct')
  d = t.order-1;
  t = t.knots;
end

grev = aveknt(t, d+1);
[f g] = bssupp(t, d, grev);
bound = struct('type', 'init', 'deg', d, 'knots', t, ...
	       'grev', grev, 'lind', f, 'rind', g);

