function bd = bdexp(t, d)
% bd = bdexp(t, d)
% bd = bdexp(sp)
% BDEXP  -- Return a structure filled with the fields used frequently by
%           the bound routines. 
%           Input can either be a knot sequence T and a degree D or
%           a structure SP as returned by SPMAK in the splines toolbox.
%           Only the knots and the order from SP will be used.
%
%           Both forms return a structure with the following fields:
%              type       : 'exp'
%              deg        : the degree D
%              knots      : the original knot sequence T
%              grev       : the Greville abscissae
%              lind, rind : For each Greville abscissa, the index of the
%                           first and last non-zero basis function there
%              beta       : Cell array with one entry for each Greville
%                           abscissa. beta{k} contains a matrix with the
%                           B--spline coefficients of the non-trivial
%                           beta in each row (these are \beta_{ki} with
%                           i=lind..rind) 
%              val        : Cell array with one entry for each Greville
%                           abscissa. val{k}(i) = \beta_{ki}(t_k^*)

% Created by lutter on Tue Dec 15 14:51:45 1998
%
%

if nargin < 2
  bd = bdinit(t);
else
  bd = bdinit(t, d);
end

t = bd.knots;
d = bd.deg;

bd.type = 'exp';

grev = bd.grev;
m = length(grev);

bd.val = cell(1, m);
bd.beta = cell(1, m);

[f, g] = bssupp(bd.knots, bd.deg);

for l=1:m
  bd.beta{l} = zeros(f(l)-g(l)+1, m);
  for i=f(l):g(l)
    if i <= l
      bd.beta{l}(i+1-f(l), f(l)-1:i) = grev(i) - grev(f(l)-1:i);
    else
      bd.beta{l}(i+1-f(l), i:g(l)+1) = grev(i:g(l)+1) - grev(i);
    end
  end
end

n = g - f + 1;
for l=1:(m-1)
  bd.val{l} = zeros(1, n(l));
  for i=1:n(l)
    bd.val{l}(i) = fnval(spmak(t, bd.beta{l}(i,:)), grev(l));
  end
end
bd.val{m} = zeros(1, g(m-1)-f(m-1)+1);