function grev = plotgrev(knots, d, uniqknots, labels)
% grev = plotgrev(knots, d, [uniqknots])
% PLOTGREV -- Plot knots, Greville abscissae and support of the B-spline
%             basis functions for the B-spline basis over the knot seq.
%             KNOTS of degree D.

% Created by lutter on Wed Oct 14 12:45:11 1998
%
%

if nargin < 3
  uniqknots = 0;
end
if nargin < 4 
  labels = 1;
end

global linewidth cblack cblue cgrey
fontsize = 17;

k = length(knots);
m = k - d - 1;
grev = knots(2:(k-d));
for j=3:(d+1)
  grev = grev+knots(j:(j+k-d-2));
end
grev = grev / d;

cla;

%% Label Greville abscissae
for i=1:m
  hl = plot([grev(i) grev(i)], [0.1 1], 'b');
  set(hl, 'LineWidth', linewidth, 'Color', cblue);
  if labels
    hl = text(grev(i)-0.02, 1.2, sprintf('%d', i-1));
    set(hl, 'FontSize', fontsize, 'FontWeight', 'bold');
  end
end

%% Show support
for i=1:m
  hl = plot([knots(i) knots(i+d+1)], [i/(m+1) i/(m+1)], 'g');
  set(hl, 'LineWidth', 2*linewidth, 'Color', cgrey);
%  hl=text(knots(1)-0.2, i/(m+1), sprintf('%d', i-1));
%  set(hl, 'FontSize', fontsize, 'FontWeight', 'bold');
end

%% Plot knots
for i=1:k
  line([knots(i) knots(i)], [0, 0.9], 'Color', cblack);
end


ymin = 0;
if labels
  %% Label knots
  ystep = 0.07;
  for i=1:k
    if ~uniqknots | i==1 | knots(i-1)~=knots(i)
      if i==1 | knots(i-1)~=knots(i)
	y = - 0.15;
      else
	y = y - ystep;
      end
      ymin = min([y, ymin]);
      hl = text(knots(i)-0.02, y, sprintf('%d', i-1));
      set(hl, 'FontSize', fontsize, 'FontWeight', 'bold');
      rect = get(hl, 'Extent');
      ystep = 1.55*rect(4);
    end
  end
end


set(gca, 'YLim', [ymin 1.2]);
set(gca, 'XLim', [knots(1)-0.1, knots(k)+0.1]);
axis off;
