function  plotbeta(t, d, ccolor)
% plotbeta(t, d)
% PLOTBETA -- Plot the betas for the knot sequence T and degree D

% Created by lutter on Tue Dec 15 11:52:32 1998
%
%

global corange cblack cblue

if nargin< 3 ccolor = cblack; end;

bd = bdexp(t, d);

k = length(bd.knots);
m = length(bd.grev);

line(bd.grev, zeros(1,m), 'LineStyle', 'none', 'Marker', 's', ...
     'MarkerFaceColor', cblue);

line(bd.knots, zeros(1,k)-.01, 'LineStyle', 'none', 'Marker', 's', ...
     'MarkerFaceColor', corange, 'Color', corange);

f = bd.lind;
g = bd.rind;
xmin = max(bd.knots(d+1), bd.grev(1));
xmax = min(bd.knots(k-d), bd.grev(m));
for l=1:(m-1)				% For each interval
  b = bd.beta{l};
  v = bd.val{l};
  if xmin <= bd.grev(l) & xmax >= bd.grev(l+1)
    for i=f(l):g(l)			% Plot beta_{l,i}
      sp = spmak(bd.knots, b(i+1-f(l), :));
      x = linspace(bd.grev(l), bd.grev(l+1), 200);
      y = fnval(sp, x);
      line(x, y, 'Color', ccolor);
    end
  end
end
axis on;