function [lower, upper] = bdspan(bd, ctrl)
% [lower, upper] = bsspan(bound, ctrl)
% BSSPAN -- For the bound defined by BOUND and the spline with control
%           points CTRL return LOWER and UPPER such that
%           lower <= spline - ctrl_poly <= upper

% Created by lutter on Tue Nov 10 18:24:54 1998
%
%

m = length(bd.grev);
diff2 = bddiff(bd, ctrl);

if strcmp(bd.type, 'cheap')
  diff2 = abs(diff2);
  upper = zeros(1, m);
  for l=1:m
    upper(l) = bd.z(l) * max(diff2(bd.lind(l):bd.rind(l)));
  end
  lower = -upper;
elseif strcmp(bd.type, 'exp')
  lower = zeros(1, m);
  upper = zeros(1, m);
  diff2p = max([diff2; zeros(1, m)]);
  diff2m = min([diff2; zeros(1, m)]);
  for l=1:(m-1)
    upper(l) = diff2p(bd.lind(l):bd.rind(l)) * bd.val{l}';
    lower(l) = diff2m(bd.lind(l):bd.rind(l)) * bd.val{l}';
  end
elseif strcmp(bd.type, 'reif')
  d = bd.deg;
  t = bd.knots;
  j = 2:m;
  sp = fnder(spmak(t, ctrl), 2);
  d2 = [0 0 abs(sp.coefs) ];
  upper = zeros(1, m);
  for l=1:m
    ind = max(l-d+2, 2):min(l, m-1);
    if isempty(ind)
      M = 0;
    else
      M = max(d2(bd.lind(l):bd.rind(l)));
    end
    %% Sloppy: there is a max(bd.z(j), bd.z(j+1)) missing !
    upper(l) = max(bd.z(max(l-1,1):min(l+1,m))) * M;
    % upper(l) = bd.z(l) * M;
  end
  lower = -upper;
else
  error ('Unknown type for bd.');
end
