function zeta = bszeta(t, d, grev)
% zeta = bszeta(t, d, [grev])
% BSZETA -- Compute the zetas for B--splines of degree D over the knot
%           sequence T

% Created by lutter on Thu Oct 22 16:47:01 1998
%
%
if nargin < 3
  grev = aveknt(t, d+1);
end
m = length(grev);
zeta = zeros(1,m);
zeta(m) = (m+1)*grev(m);
for i=(m-1):-1:1
  zeta(i) = zeta(i+1) - (i+1)/d*(t(i+d+1)-t(i+1));
end
