function bd = bdubeta(t, d)
% bd = bdubeta(t, d)
% bd = bdubeta(sp)
% BDUBETA -- Return a structure filled with the fields used frequently by
%            the bound routines. 
%            Input can either be a knot sequence T and a degree D or
%            a structure SP as returned by SPMAK in the splines toolbox.
%            Only the knots and the order from SP will be used.
%
%            Both forms return a structure with the following fields:
%               type       : 'init'
%               deg        : the degree D
%               knots      : the original knot sequence T
%               grev       : the Greville abscissae
%               lind, rind : For each Greville abscissa, the index of the
%                            first and last non-zero basis function there
%               beta       :
%               val        :

% Created by lutter on Tue Dec 15 14:51:45 1998
%
%

if nargin < 2
  bd = bdexp(t);
else
  bd = bdexp(t, d);
end

m = length(bd.grev);
d2 = floor(d/2)-1;
bd.lind = max([(1:m) - d2; ones(1, m)]);
bd.rind = min([(1:m) + d2; m*ones(1,m)]);
n = bd.deg;
for i = 1:length(bd.grev)
  bd.val{i} = bd.val{n+1}(1:bd.rind(i)-bd.lind(i)+1);
  bd.beta{i} = bd.beta{n+1}(1:bd.rind(i)-bd.lind(i)+1, :);
end

