function tst_channel()
% TST_CHANNEL -- Test driver for the channel solver
% 

% Created by lutter on Wed Apr 26 12:57:58 2000


%%% First example
%% Fit a cubic spline
bd = bdexp([0 0 0 0 .45 1/2 .55 1 1 1 1], 3);
a = spmak([0 0 1/2 1 1], [0 1 0]);
c = spmak([0 0 1/2 1 1], [1/16 17/16 1/16]);

clf;
drawchannel(bd, a, c);
disp('Press <RETURN> to continue');
pause

%%% Second example
%% Fit a quadratic spline
t = [ 0 0 0 1:5 6 6 6];
bd = bdexp(t, 2);
x = 0:6;
a = [ 0 1.5 1.5 .25 1.5 1.5 0];
c = a + 1;
m = length(x);

spa = spmak(x([1 1:m m]), a);
spc = spmak(x([1 1:m m]), c);
clf;
drawchannel(bd, spa, spc);
disp('Press <RETURN> to continue');
pause

%%% Third example
%% Fit a cubic with control points at the breaks of 
%% the input polygon
t = [0 0 0 0 1:5 6 6 6 6];
clf;
drawchannel(bdexp(t,3), spa, spc);

function sp = drawchannel(bd, a, c)
  global linewidth cblack cred

  p = fnplt(a);
  line(p(1,:), p(2,:), 'LineWidth', linewidth, 'Color', cred);
  p = fnplt(c);
  line(p(1,:), p(2,:), 'LineWidth', linewidth, 'Color', cred);

  sp = channel(bd, a, c);

  plotenv(bd, sp.coefs, 'DrawCPoly', 0);
