function z = plotzeta(t, d)
%% plotzeta(t, d)
%% PLOTZETA -- Plot the function z (not zeta :) for the B-spline basis
%              over the knot sequence T of degree D

%% Display parameters
global cblack cblue cbackground corange

k = length(t);
m = k - d - 1;
grev = aveknt(t, d+1);
zeta = bszeta(t,d, grev);

z = fncmb(spmak(t, zeta), '-', spmak(grev([1 1:m m]), zeta));

%% Compute the bounding constant for each subinterval
[f, g] = bssupp(t, d, grev);
bound = fnval(z, grev);
maxbound = max(bound);
for i = 1:m
  line([grev(i) grev(i)], [0 bound(i)], 'Color', cblue);
end

%% Plot the z_k
x = linspace(grev(1), grev(m), 100);
x = sort([x grev(2:(m-1))]);
y = fnval(z, x);
line(x, y, 'Color', cblack);

set(gca, 'Visible', 'on');
set(gca, 'XTick', knt2brk(t));