% DEMO -- Shows examples of how to use the bsbound routines

% Created by lutter on Mon Feb  8 11:48:00 1999
%
%

figdefault('color');			% Set color scheme

%%
%% Plot the Greville abscissae & support for a cubic B-spline
%% basis.
%%
clf;
disp('Knots and Greville abscissae for a cubic basis:');
plotgrev([0 0 0 0 1 2 4 4 4 4], 3);
disp('Press a key to continue.');
pause;

%%
%% Plot the `cheap' bound (Corollary 3.4 in the paper)
%%

disp('The constants needed for the cheap bound:');
bd = bdcheap([0 0 0 0 1 2 4 4 4 4], 3)
clf;
plotenv(bd, [0 1 3 0 3 2]);
disp('Press a key to continue.');
pause;

%%
%% Plot the `expensive' bound (Corollary 3.2 in the paper)
%%

disp('The constants needed for the expensive bound:');
bd = bdexp([0 0 0 0 0 0 1 3 7 7 7 7 7 7], 5)
for i=1:length(bd.grev)
  fprintf('bd.val{%d}: ', i);
  fprintf('%12f ', bd.val{i});
  fprintf('\n');
end
clf;
plotenv(bd, [0 1 2 0 0 1 1 0]);
disp('Press a key to continue.');
pause;

%%
%% Plot the function z for the last example:
%%
clf;
disp('The function z for the last example:');
plotzeta(bd.knots, bd.deg);
disp('Press a key to continue.');
pause;
