function [f, g] = bssupp(t, d, grev)
% [f, g] = bssupp(t, d, [grev])
% BSSUPP -- Compute the first and last index of the basis function that
%           is ~= 0 at the Greville abscissae

% Created by lutter on Thu Oct 22 16:38:02 1998
%
%

if nargin < 3
  grev = aveknt(t, d+1);
end

m = length(grev);
f = zeros(1, m);
g = zeros(1, m);
for l=1:m
  f(l) = max([1, find(t<=grev(l))-d] + 1);
  g(l) = min([m, find(t>grev(l))-1] - 1);
end
g(1) = max([g(1), d]);
f(m) = min([f(m), m - d + 1]);
