function bd = bdcheap(t, d)
% bd = bdcheap(t, d)
% bd = bdcheap(sp)
% BDCHEAP -- Compute the parts of the cheap B-spline bound that only
%            depend on the knot sequence.
%            Input can either be a knot sequence T and a degree D or
%            a structure SP as returned by SPMAK in the splines toolbox.
%            Only the knots and the order from SP will be used.
%
%            Both forms return a structure with the following fields:
%              type       : 'cheap'
%              deg        : the degree D
%              knots      : the original knot sequence T
%              grev       : the Greville abscissae
%              lind, rind : For each Greville abscissa, the index of the
%                           first and last non-zero basis function there
%              z          : the function z_k evaluated at grev(k)
%              

% Created by lutter on Fri Jan 22 16:23:50 1999
%
%

if nargin < 2 				% When will MATLAB get optional args ?
  bd = bdinit(t);
else
  bd = bdinit(t, d);
end

m = length(bd.grev);
d = bd.deg;
t = bd.knots;

ctrl_zeta = bszeta(t, d);
zeta = spmak(t, ctrl_zeta);
bd.z = fnval(zeta, bd.grev) - ctrl_zeta;
bd.type = 'cheap';